import json
from pathlib import Path

from mow.dataset.chat import ChatDatasetBuilder


class AutoChatDatasetBuilder:
    datasets: dict[str, type[ChatDatasetBuilder]] = {}

    @classmethod
    def register(
        cls, dataset_type: str, builder_cls: type[ChatDatasetBuilder]
    ) -> None:
        cls.datasets[dataset_type] = builder_cls

    @classmethod
    def load(
        cls,
        dataset_path: str | Path,
        keep_in_memory: bool | None = None,
        storage_options: dict | None = None,
        **options,
    ) -> ChatDatasetBuilder:
        with open(f"{dataset_path}/dataset_info.json") as f:
            info = json.load(f)
        builder_cls = cls.datasets.get(info.get("type"), None)
        if builder_cls is not None:
            return builder_cls.load(
                dataset_path,
                keep_in_memory=keep_in_memory,
                storage_options=storage_options,
                **options,
            )
        raise ValueError(
            "Unsupported dataset format. Please check the dataset format. "
            "If you made a new dataset type, please register it using "
            "AutoChatDataset.register()"
        )
