from typing import override

from mow.dataset.auto import AutoChatDatasetBuilder
from mow.dataset.chat import ChatDatasetBuilder

BASE_PROMPT = (
    "You are a home robot agent. You can use 9 skills, (open [object], "
    "pick [object], place on [object], close [object], wipe [object], pour "
    "[object], sweep [object], flip [object], push [object]). If the question "
    'is "Action:" you should answer with a skill. If the question is "Next '
    'observation:" you should answer with the next observation. You must '
    "answer only with what is requested and nothing else."
)


class RealworldDatasetBuilder(ChatDatasetBuilder):
    @override
    @classmethod
    def _convert_to_chat(
        cls, example, /, *, action_only: bool = False, **_
    ) -> list[dict[str, str]]:
        chat = [
            {"role": "system", "content": BASE_PROMPT},
            {
                "role": "user",
                "content": (
                    f"Instruction: {example['instruction']}\n\n"
                    f"Observation: {example['observation']}\n\n"
                    f"Action: "
                ),
            },
            {"role": "assistant", "content": example["action"]},
        ]
        if not action_only:
            if example["next_observation"] is None:
                raise ValueError(
                    "next_observation is None, but action_only is False"
                )
            chat.append(
                {"role": "user", "content": "Next observation: "},
            )
            chat.append(
                {"role": "assistant", "content": example["next_observation"]},
            )
        return chat


AutoChatDatasetBuilder.register("realworld", RealworldDatasetBuilder)
