INSTRUCTION_SET = [
    "If no one is watching the TV, turn it off.",
    "If the radio is on alone, turn it off",
    "If your microwave is on and spinning, turn it off.",
    "If the stove is on, go and turn it off.",
    "If your computer stays on, turn it off",
    "If the cabinet is open, close it.",
    "If you have an apple somewhere, bring it to your desk.",
    "If you see a book somewhere unorganized, bring it to the sofa.",
    "The dishwasher must always be open to dry the dishwasher.",
    "It is good for maintenance if the microwave is always open.",
    "Always leave the stove open.",
    "The mug should always be on the coffeetable.",
    "To wash dishes, place the plates in the microwave as shown.",
    "If you see towels, put them in the washingmachine.",
    "If your towel isn't stored somewhere else, put it in the closet.",
    "If someone reads a book and doesn't tidy it up, put it back.",
    "Put paper on the floor or anywhere else in the cabinet.",
    "Place all visible mug in the microwave to sterilize them.",
    "If someone uses a plate for washing dishes and leaves it somewhere, put it in the dishwasher."
]

TASKS_SET = {
    "Turn on tv": [("tv", "is", "on")],
    "Turn on radio": [("radio", "is", "on")],
    "Turn on microwave": [("microwave", "is", "on")],
    "Turn on stove": [("stove", "is", "on")],
    "Turn on computer": [("computer", "is", "on")],
    "Turn on coffeemaker": [("coffeemaker", "is", "on")],
    "Turn on dishwasher": [("dishwasher", "is", "on")],
    "Turn on faucet": [("faucet", "is", "on")],
    "Turn on toaster": [("toaster", "is", "on")],

    "Open cabinet": [("cabinet", "is", "open")],
    "Open dishwasher": [("dishwasher", "is", "open")],
    "Open microwave": [("microwave", "is", "open")],
    "Open stove": [("stove", "is", "open")],
    "Open coffeepot": [("coffeepot", "is", "open")],
    "Open toilet": [("toilet", "is", "open")],
    "Open fridge": [("fridge", "is", "open")],

    "Put apple on desk": [("apple", "on", "desk")],
    "Put remotecontrol on desk": [("remotecontrol", "on", "desk")],
    "Put notes on desk": [("notes", "on", "desk")],
    "Put book on desk": [("book", "on", "desk")],
    "Put mug on desk": [("mug", "on", "desk")],
    "Put book on sofa": [("book", "on", "sofa")],
    "Put chips on sofa": [("chips", "on", "sofa")],
    "Put clock on sofa": [("clock", "on", "sofa")],
    "Put folder on sofa": [("folder", "on", "sofa")],
    "Put milk on sofa": [("milk", "on", "sofa")],
    "Put cereal on coffeetable": [("cereal", "on", "coffeetable")],
    "Put mug on coffeetable": [("mug", "on", "coffeetable")],
    "Put cutleryfork on coffeetable": [("cutleryfork", "on", "coffeetable")],
    "Put coffeepot on coffeetable": [("coffeepot", "on", "coffeetable")],
    "Put waterglass on coffeetable": [("waterglass", "on", "coffeetable")],
    "Put plate on microwave": [("plate", "on", "microwave")],
    "Put salmon on microwave": [("salmon", "on", "microwave")],
    "Put bananas on microwave": [("bananas", "on", "microwave")],
    "Put apple on microwave": [("apple", "on", "microwave")],
    "Put mug on microwave": [("mug", "on", "microwave")],
    "Put mug to tvstand": [("mug", "on", "tvstand")],
    "Put book on tvstand": [("book", "on", "tvstand")],
    "Put notes to tvstand": [("notes", "on", "tvstand")],
    "Put waterglass on tvstand": [("waterglass", "on", "tvstand")],
    "Put remotecontrol on tvstand": [("remotecontrol", "on", "tvstand")],
    "Put cellphone on bed": [("cellphone", "on", "bed")],
    "Put keyboard on bed": [("keyboard", "on", "bed")],
    "Put folder on bed": [("folder", "on", "bed")],
    "Put cereal on bed": [("cereal", "on", "bed")],
    "Put box on bed": [("box", "on", "bed")],

    "Place towel in closet": [("towel", "inside", "closet")],
    "Place keyboard in closet": [("keyboard", "inside", "closet")],
    "Place folder in closet": [("folder", "inside", "closet")],
    "Place mouse in closet": [("mouse", "inside", "closet")],
    "Place book in bookshelf": [("book", "inside", "bookshelf")],
    "Place folder in bookshelf": [("folder", "inside", "bookshelf")],
    "Place magazine in bookshelf": [("magazine", "inside", "bookshelf")],
    "Place paper in bookshelf": [("paper", "inside", "bookshelf")],
    "Place box in bookshelf": [("box", "inside", "bookshelf")],
    "Place plum in cabinet": [("plum", "inside", "cabinet")],
    "Place mug in cabinet": [("mug", "inside", "cabinet")],
    "Place cereal in cabinet": [("cereal", "inside", "cabinet")],
    "Place cupcake in cabinet": [("cupcake", "inside", "cabinet")],
    "Place paper in cabinet": [("paper", "inside", "cabinet")],
    "Place towel in cabinet": [("towel", "inside", "cabinet")],
    "Place box in cabinet": [("box", "inside", "cabinet")],
    "Place keyboard in cabinet": [("keyboard", "inside", "cabinet")],
    "Place box in closet": [("box", "inside", "closet")],
    "Place slippers in closet": [("slippers", "inside", "closet")],
    "Place cutleryknife in dishwasher": [("cutleryknife", "inside", "dishwasher")],
    "Place plate in dishwasher": [("plate", "inside", "dishwasher")],
    "Place mug in dishwasher": [("mug", "inside", "dishwasher")],
    "Place cutleryfork in dishwasher": [("cutleryfork", "inside", "dishwasher")],
    "Place milk in fridge": [("milk", "inside", "fridge")],
    "Place juice in fridge": [("juice", "inside", "fridge")],
    "Place apple in fridge": [("apple", "inside", "fridge")],
    "Place plum in fridge": [("plum", "inside", "fridge")],
    "Place carrot in fridge": [("carrot", "inside", "fridge")],
    "Place breadslice in microwave": [("breadslice", "inside", "microwave")],
    "Place cupcake in microwave": [("cupcake", "inside", "microwave")],
    "Place pancake in microwave": [("pancake", "inside", "microwave")],
    "Place pie in microwave": [("pie", "inside", "microwave")],
}

# SUCCESS_CONDITIONS =  [
#     ("apple", "on", "desk"),
#     ("paper", "on", "desk"),
#     ("notes", "on", "desk"),
#     ("book", "on", "desk"),
#     ("mug", "on", "desk"),
#
#     ("book", "on", "sofa"),
#     ("notes", "on", "sofa"),
#     ("clock", "on", "sofa"),
#     ("folder", "on", "sofa"),
#     ("milk", "on", "sofa"),
#
#     ("mug", "on", "coffeetable"),
#     ("mug", "on", "coffeetable"),
#     ("mug", "on", "coffeetable"),
#     ("mug", "on", "coffeetable"),
#     ("mug", "on", "coffeetable"),
#
#     ("mug", "on", "coffeetable"),
#     ("plate", "on", "microwave"),
#     ("towel", "on", "washingmachine"),
#     ("lime", "on", "coffeetable"),
#     ("mug", "on", "tvstand"),
#     ("book", "on", "tvstand"),
#     ("paper", "on", "desk"),
#     ("notes", "on", "desk"),
#     ("plate", "on", "coffeetable"),
#
#     ("towel", "inside", "closet"),
#     ("book", "inside", "bookshelf"),
#     ("paper", "inside", "cabinet"),
#     ("mug", "inside", "microwave"),
#     ("plate", "inside", "dishwasher"),
#     ("apple", "inside", "fridge"),
#     ("notes", "inside", "garbagecan"),
#     ("paper", "inside", "printer"),
#     ("lime", "inside", "fridge"),
#     ("notes", "inside", "bookshelf"),
#     ("plate", "inside", "microwave"),
#     ("towel", "inside", "washingmachine"),
# ]

QUERIES_SET = [
    "tv is off",
    "radio is off",
    "microwave is off",
    "stove is off",
    "computer is off",
    "cabinet is closed",
    "character hold apple apple on ",
    "character hold book or book on ",
    "dishwasher is closed",
    "microwave is closed",
    "stove is closed",
    "character hold mug or mug on ",
    "character hold plate or plate on ",
    "character hold towel or towel on ",
    "character hold towel or towel on ",
    "character hold book or book on ",
    "character hold paper or paper on ",
    "character hold mug or mug on ",
    "character hold plate or plate on ",
]

NON_STA_SETTINGS = {
    "high": 4,
    "medium": 6,
    "low": 8,
}

NON_STA_ACTION = [
    ("switchoff", "tv"),
    ("switchoff", "radio"),
    ("switchoff", "microwave"),
    ("switchoff", "stove"),
    ("switchoff", "computer"),
    ("close", "cabinet"),
    ("place", "apple"),
    ("place", "book"),
    ("close", "dishwasher"),
    ("close", "microwave"),
    ("close", "stove"),
    ("place", "mug"),
    ("place", "plate"),
    ("place", "towel"),
    ("place", "towel"),
    ("place", "book"),
    ("place", "paper"),
    ("place", "mug"),
    ("place", "plate"),
]

BASE_PROMPT = "You are a home robot agent. You can use 6 skills, (walk [object or room], grab [object], switch [object], putin [object], put [object], open [object]). "
BASE_PROMPT += "The walk skill only works on objects in the same room or another rooms. The remaining interaction skills can be used if the object is close from agent by walking. "
BASE_PROMPT += "room: livingroom, bathroom, kitchen, livingroom.\n\n"


ROOMS = ["kitchen", "bedroom", "livingroom", "bathroom"]
OBJECTS = [
    "alcohol", "amplifier", "apple", "bananas", "barsoap", "bathtub", "bellpepper", "bench",
    "boardgame", "book", "bottlewater", "breadslice", "cabinet", "carrot", "ceilingfan", "cellphone", "cereal",
    "chair", "chicken", "chips", "clock", "closet", "coffeetable", "computer", "cookingpot", "crayons", "cupcake",
    "curtains", "cutleryfork", "cutleryknife", "cutlets", "cuttingboard", "deodorant", "desk", "dishwasher", "faucet",
    "folder","fridge", "fryingpan", "garbagecan", "hairproduct", "hanger", "juice", "keyboard", "knifeblock",
    "lightswitch", "lime", "magazine", "microwave", "milk", "milkshake", "mincedmeat", "mouse", "mousemat",
    "mug", "nightstand", "notes", "painkillers", "pancake", "paper", "papertray", "peach", "pear",
    "perfume", "photoframe", "pie", "plate", "plum", "poundcake", "printer", "pudding",
    "radio", "remotecontrol", "salad", "salmon", "sink", "sofa", "speaker", "stove", "stovefan", "tablelamp",
    "toaster", "toiletpaper", "toothbrush", "toothpaste", "towel", "toy", "tv", "tvstand", "washingmachine",
    "sponge", "waterglass", "whippedcream", "wine", "wineglass", "wallshelf"
]

BASE_COMPONENT = ['Walls', 'Ceiling', 'Lamps', 'Floor', 'Decor', 'Floors', 'Doors', 'Windows']

room_adjacent = {
    0: [["kitchen", "bedroom"], ["bedroom", "bathroom"], ["livingroom", "kitchen"]],
    1: [["kitchen", "bathroom"], ["bedroom", "kitchen"], ["livingroom", "kitchen"]],
    5: [["kitchen", "bedroom"], ["bedroom", "bathroom"], ["livingroom", "bedroom"]],
    6: [["kitchen", "bathroom"], ["bedroom", "kitchen"], ["livingroom", "kitchen"]],
    7: [["bedroom", "bathroom"], ["bedroom", "kitchen"], ["livingroom", "kitchen"]],
    8: [["bedroom", "bathroom"], ["bedroom", "kitchen"], ["livingroom", "kitchen"]],
    9: [["bedroom", "bathroom"], ["bedroom", "kitchen"], ["livingroom", "kitchen"]],
    12: [["bedroom", "bathroom"], ["bedroom", "kitchen"], ["livingroom", "kitchen"]],
    13: [["bedroom", "kitchen"], ["kitchen", "livingroom"], ["livingroom", "bathroom"]],
    15: [["kitchen", "bathroom"], ["bedroom", "kitchen"], ["livingroom", "kitchen"]],
    18: [["kitchen", "bathroom"], ["bedroom", "kitchen"], ["livingroom", "kitchen"]],
    20: [["bedroom", "bathroom"], ["bedroom", "kitchen"], ["livingroom", "kitchen"]],
    22: [["bedroom", "kitchen"], ["kitchen", "livingroom"], ["livingroom", "bathroom"]],
    24: [["kitchen", "bathroom"], ["bedroom", "kitchen"], ["livingroom", "kitchen"]],
    26: [["kitchen", "bathroom"], ["bedroom", "livingroom"], ["livingroom", "kitchen"]],
    28: [["bedroom", "bathroom"], ["kitchen", "bedroom"], ["livingroom", "kitchen"]],
    29: [["bedroom", "bathroom"], ["kitchen", "bedroom"], ["livingroom", "kitchen"]],
    31: [["bedroom", "kitchen"], ["livingroom", "kitchen"], ["livingroom", "bathroom"]],
    32: [["bedroom", "kitchen"], ["livingroom", "kitchen"], ["livingroom", "bathroom"]],
    34: [["bedroom", "kitchen"], ["livingroom", "kitchen"], ["livingroom", "bathroom"]],
}

task_related_object = [
    'tv',
    'microwave',
    'stove',
    'computer',
    'lightswitch',
    'radio',
    'mug',
    'apple',
    'towel',
    'fridge',
    'fryingpan',
    'book',
    'paper',
    'plate',
    'closet',
    'cabinet',
    'coffeetable',
    "wallshelf",
    "bookshelf",
    "desk",
    "tvstand",
    "bathroomcounter"
]
