import unittest

from mow.utils.graph import Graph


class Edge:
    def __init__(self, source: str, target: str):
        self.source = source
        self.target = target


class TestGraph(unittest.TestCase):
    def setUp(self):
        self.graph = Graph[str]()
        self.graph.add_edge(Edge("A", "B"))
        self.graph.add_edge(Edge("A", "C"))
        self.graph.add_edge(Edge("B", "D"))
        self.graph.add_edge(Edge("C", "D"))
        self.graph.add_edge(Edge("D", "A"))
        self.graph.add_edge(Edge("D", "B"))

    def test_add_edge(self):
        self.graph.add_edge(Edge("D", "E"))
        self.assertIn("E", self.graph.get_neighbors("D"))

    def test_has_edge(self):
        self.assertTrue(self.graph.has_edge("A", "B"))
        self.assertFalse(self.graph.has_edge("A", "E"))

    def test_get_neighbors(self):
        neighbors = self.graph.get_neighbors("A")
        self.assertCountEqual(neighbors, ["B", "C"])

    def test_path_exists(self):
        self.assertTrue(self.graph.path_exists("A", "D"))
        self.assertFalse(self.graph.path_exists("A", "E"))

    def test_get_k_nearest_neighbors(self):
        neighbors = self.graph.get_k_nearest_neighbors("A", k=2)
        self.assertCountEqual(neighbors, ["B", "C"])


if __name__ == "__main__":
    unittest.main()
