This repository modifies the official implementations and experiments for [LSSAE](https://proceedings.mlr.press/v162/qin22a/qin22a.pdf) and [MMD-LSAE](https://ieeexplore.ieee.org/abstract/document/10268347), and adds the implementation of [BayesShift] using HMC for latent posterior distribution sampling. The core codes for implementing these models can be found in [network/vae_algorithms.py](network/vae_algorithms.py). Please follow the [steps](#datasets) below to prepare the datasets, install the required packages, and run the code. 


### Datasets
- [Circle](https://drive.google.com/file/d/1kWyunwxMXGJI5lARqTuJUFP8_gZ3nFA-/view?usp=sharing)/[Circle-C](https://drive.google.com/file/d/1LM2aWS-d4d47syWROkM57oI2AGZ-hnD2/view?usp=sharing)  [![DOI](https://zenodo.org/badge/DOI/10.1007/978-3-319-46227-1_7.svg)](https://doi.org/10.1007/978-3-319-46227-1_7)
- [Sine](https://drive.google.com/file/d/1E0Z4wxPjQKvWESlZdmt70A6B9SBOXSsw/view?usp=sharing)/[Sine-C](https://drive.google.com/file/d/1l15E_RX9zlvicSYur_Bwdqm7t-LbcKri/view?usp=sharing) [![DOI](https://zenodo.org/badge/DOI/10.1007/978-3-319-46227-1_7.svg)](https://doi.org/10.1007/978-3-319-46227-1_7)
- [RMNIST](http://yann.lecun.com/exdb/mnist/) [![DOI](https://zenodo.org/badge/DOI/10.1109/ICCV.2015.293.svg)](https://doi.org/10.1109/ICCV.2015.293)
- [Portraits](https://drive.google.com/file/d/1nvKn2pwaU6vr7Zmo6DTSts2i5Ik_--DW/view?usp=sharing) [![DOI](https://zenodo.org/badge/DOI/10.1109/TCI.2017.2699865.svg)](https://doi.org/10.1109/TCI.2017.2699865)
- [Caltran](https://drive.google.com/file/d/1x-23eDB1ksE2qKDbpA8vwmBRsWD6jiJw/view?usp=sharing) [![DOI](https://zenodo.org/badge/DOI/10.1109/CVPR.2014.116.svg)](https://doi.org/10.1109/CVPR.2014.116)
- [Airline](https://drive.google.com/drive/folders/1NSLLmUUQqtsF8GqaXjrEII-BZ6Rh8BVd?usp=drive_link) [🔗](https://kt.ijs.si/elena_ikonomovska/data.html)
- [ONP](https://drive.google.com/drive/folders/148MHxla5yhrC62VISv0xwXGQkH3TEK7b?usp=drive_link) [![DOI](https://zenodo.org/badge/DOI/10.1007/978-3-319-23485-4_53.svg)](https://doi.org/10.1007/978-3-319-23485-4_53)
- [PowerSupply](https://drive.google.com/file/d/11AXm-kcSWk2LBhaNEMm56UVm7Evhj793/view?usp=sharing) [![DOI](https://zenodo.org/badge/DOI/10.1109/JAS.2019.1911747.svg)](https://doi.org/10.1109/JAS.2019.1911747)

We provide the Google Drive links here, so you can download these datasets directly and move them to your own file path for storage.


### Requirements

- python 3.8
- Pytorch 1.10 or above
- Pyyaml
- tqdm
- hamiltorch


### 🚀 Quick Start

#### 1. Toy Circle
```
cd ./LSSAE
chmod +x ./scripts/*

# 1. Specify the path for Circle
    --data_path "/data/Toy_Circle/half-circle.pkl" 

# 2. Run script for BayesShift
./scripts/train_circle_bayesshift.sh 
```


#### 2. Other Datasets

To apply our method to other datasets, we can first copy the script of train_circle_*.sh directly, then specify the dataset information and employed network architectures. Here, an example for RMNIST is provided :
```
# 1. Specify the dataset info for RMNIST
    --data_path "/data/DataSets" 
    --num_classes 10 
    --data_size '[1, 28, 28]' 
    --source-domains 10 
    --intermediate-domains 3 
    --target-domains 6 

# 2. Specify the feature extractor and classifier
    --model-func MNIST_CNN
    --cla-func Linear_Cla

# 3. Run script for BayesShift
./scripts/train_rmnist_bayesshift.sh
```

See [./logs](./logs) for running records. 


### Acknowledgments

Codes are modified on the original repository by the following repo: [LSSAE/MMD-LSAE](https://github.com/WonderSeven/LSSAE).