import os
import json
from collections import defaultdict

# Path to the directory containing the result files
result_dir = "/root/autodl-tmp/ada-place/benchmarks/online_exp/result/end2end/exp1"

# Dictionary to store the parsed file information
file_info = defaultdict(list)

# Traverse the files in the directory
for filename in os.listdir(result_dir):
    if filename.endswith(".json"):
        # Get the full path to the file
   
        filename_prefix = filename[:-5]
        # Extract just the basename from the path
        # Split the filename by "_"
        parts = filename_prefix.split("_")
        
        # Rename "lenPred" to "pred" in parts
        for i, part in enumerate(parts):
            if part == "promtps":
                parts[i] = "prompts"



        # Join the parts with "_" to create the new filename
        new_filename = "_".join(parts) + ".json"
        
        old_filepath = os.path.join(result_dir, filename)
        new_filepath = os.path.join(result_dir, new_filename)
        # Rename the file
        os.rename(old_filepath, new_filepath)