# Code for the experiments in Sections 4.2 and 4.3 on the Blur data formation for the sequential search space from Section 3.1.1

# Setup:
dataset=Blur
layers=10
runs=75
noise=10

#############################################
# Table 1 (Blur) :
for j in $(eval echo "{0..$runs}"); do
  for op in all-learnable all-good-learnable learnable_grad net all-learnable-random all-good-learnable-random; do
	python search_IP_NAS.py --channels 64 --cell_steps 1 --dataset $dataset --layers $layers --operations $op --exp_name automl_$op_$layers$noise --noise_level 0.$noise --config_path configs/darts_1_BSDS_configspace.json
  done
done

#############################################
### Experiments with different hyperparameters in  Table 3 (Blur)

#H1  Figure 3(left) 
# Same code as for Table 1 (Blur) exp before 

for j in $(eval echo "{0..$runs}"); do
  for op in all-learnable all-good-learnable; do
	python search_IP_NAS.py --channels 64 --cell_steps 1 --dataset $dataset --layers $layers --operations $op --exp_name automl_h11_$op_$layers$noise --noise_level 0.$noise --config_path configs/darts_1_BSDS_configspace.json
  done
done

#H2
for j in $(eval echo "{0..$runs}"); do
  for op in all-learnable all-good-learnable; do
	python search_IP_NAS.py --channels 64 --cell_steps 1 --dataset $dataset --layers $layers --operations $op --exp_name automl_h2_$op_$layers$noise --noise_level 0.$noise --config_path configs/darts_1_BSDS_configspace2.json
  done
done

#BOHB-one-shot-Blur Figure 5 (top)(left)
for j in $(eval echo "{0..$runs}"); do
  for op in all-learnable all-good-learnable; do
	python search_IP_NAS.py --channels 64 --cell_steps 1 --dataset $dataset --layers $layers --operations $op --exp_name automl_bohb_o_s_blur_$op_$layers$noise --noise_level 0.$noise --config_path configs/DARTS_1_Blur_configspace_all-learnable_10.json
  done
done

#BOHB-one-shot-DS
for j in $(eval echo "{0..$runs}"); do
  for op in all-learnable all-good-learnable; do
	python search_IP_NAS.py --channels 64 --cell_steps 1 --dataset $dataset --layers $layers --operations $op --exp_name automl_bohb_o_s_ds_$op_$layers$noise --noise_level 0.$noise --config_path configs/DARTS_1_Downsampling_configspace_all-learnable_10.json
  done
done

#BOHB-Blur Figure 5 (bottom) (left)
for j in $(eval echo "{0..$runs}"); do
  for op in all-learnable all-good-learnable; do
	python search_IP_NAS.py --channels 64 --cell_steps 1 --dataset $dataset --layers $layers --operations $op --exp_name automl_bohb_blur_$op_$layers$noise --noise_level 0.$noise --config_path configs/DARTS_1_Blur_configspace_all-learnable_10_eval.json
  done
done




