from .hyperparameters import Hyperparameters


def _list_variants(common_defs):
    variants = []
    variants.append(Hyperparameters(name='DARTS-1th', **common_defs, update='liu', norm='none', alpha_warmup=True,
                                    alpha_scheduler='linear', mirror_descent=False, project=False, decay_entropy=False,
                                    fuse=False, alpha_optimizer='GD', alpha_lr=0.001363013777496,
                                    param_lr=0.002080693340365, weight_decay=0.006312035932002))
    variants.append(Hyperparameters(name='DARTS-project', **common_defs, update='liu', norm='none', alpha_warmup=True,
                                    alpha_scheduler='linear', mirror_descent=False, project=True, decay_entropy=False,
                                    fuse=False, alpha_optimizer='GD', alpha_lr=0.001363013777496,
                                    param_lr=0.002080693340365, weight_decay=0.006312035932002))
    variants.append(Hyperparameters(name='DARTS-norm', **common_defs, update='liu', norm='DARTS', alpha_warmup=True,
                                    alpha_scheduler='linear', mirror_descent=False, project=False, decay_entropy=False,
                                    fuse=False, alpha_optimizer='GD', alpha_lr=0.006624439023506,
                                    param_lr=0.00205703207738, weight_decay=0.008803523518533))
    variants.append(Hyperparameters(name='TemperatureDecay', **common_defs, update='liu', norm='none', alpha_warmup=False,
                                    alpha_scheduler='none', mirror_descent=False, project=False, decay_entropy=True,
                                    fuse=False, alpha_optimizer='GD', alpha_lr=0.000634114672045,
                                    param_lr=0.003311884876451, weight_decay=0.008895974077981))
    variants.append(Hyperparameters(name='TemperatureDecay-norm', **common_defs, update='liu', norm='DARTS',
                                    alpha_scheduler='linear', mirror_descent=False, project=False, decay_entropy=True,
                                    fuse=False, alpha_optimizer='Adam', alpha_lr=0.002426215428258,
                                    alpha_warmup=False, param_lr=0.001043590936711, weight_decay=0.004376784982796))
    variants.append(Hyperparameters(name='TemperatureProject', **common_defs, update='liu', norm='none', alpha_warmup=True,
                                    alpha_scheduler='none', mirror_descent=False, project=True, decay_entropy=True,
                                    fuse=False, alpha_optimizer='GD', alpha_lr=0.006192074576028,
                                    param_lr=0.002492580606271, weight_decay=0.000376135259102))
    variants.append(Hyperparameters(name='MirrorAdam', update='liu', mirror_descent=True, project=False, alpha_warmup=False,
                                    alpha_scheduler='linear', decay_entropy=True, fuse=False, alpha_optimizer='GD',
                                    alpha_lr=0.008416113747545, norm='none', **common_defs,
                                    param_lr=0.002429264129004, weight_decay=0.00080628146351))
    variants.append(Hyperparameters(name='MirrorAdam-project', update='liu', mirror_descent=True, project=True,
                                    alpha_scheduler='linear', decay_entropy=True, fuse=False, alpha_optimizer='Adam',
                                    alpha_lr=0.008416113747545, norm='none', **common_defs,
                                    alpha_warmup=True, param_lr=0.002429264129004, weight_decay=0.00080628146351))
    variants.append(Hyperparameters(name='MirrorAdam-norm', update='liu', mirror_descent=True, project=False,
                                    alpha_scheduler='linear', decay_entropy=True, fuse=False, alpha_optimizer='GD',
                                    alpha_lr=0.003456776645277, norm='DARTS', **common_defs,
                                    alpha_warmup=True, param_lr=0.00200058591784, weight_decay=0.006694337278094))
    variants.append(Hyperparameters(name='MirrorDescent', update='liu', mirror_descent=True, project=False,
                                    alpha_scheduler='linear', decay_entropy=True, fuse=False, alpha_optimizer='Adam',
                                    alpha_lr=0.000478464026995, norm='none', **common_defs,
                                    alpha_warmup=False, param_lr=0.002179744047611, weight_decay=0.000916443129264))
    variants.append(Hyperparameters(name='MirrorDescent-norm', update='liu', mirror_descent=True, project=False,
                                    alpha_scheduler='none', decay_entropy=True, fuse=False, alpha_optimizer='Adam',
                                    alpha_lr=0.00193269642621, norm='DARTS', **common_defs,
                                    alpha_warmup=True, param_lr=0.002135892531911, weight_decay=0.004440273087224))
    variants.append(Hyperparameters(name='MirrorDescent-project', update='liu', mirror_descent=True, project=True,
                                    alpha_scheduler='linear', decay_entropy=True, fuse=False, alpha_optimizer='Adam',
                                    alpha_lr=0.000478464026995, norm='none', **common_defs,
                                    alpha_warmup=True, param_lr=0.002179744047611, weight_decay=0.000916443129264))
    # # Extra stuff
    variants.append(Hyperparameters(name='DARTS-joint', **common_defs, update='joint', norm='none',
                                    alpha_scheduler='none', mirror_descent=False, project=False, decay_entropy=False,
                                    fuse=False, alpha_optimizer='Adam', alpha_lr=0.008512439060835,
                                    alpha_warmup=True, param_lr=0.007603505013317, weight_decay=0.002025342012343))
    variants.append(Hyperparameters(name='DARTS-0th', **common_defs, update='liu-0th', alpha_scheduler='none',
                                    mirror_descent=False, project=False, decay_entropy=False, norm='none',
                                    fuse=False, alpha_optimizer='Adam', alpha_lr=0.008512439060835,
                                    alpha_warmup=False, param_lr=0.007603505013317, weight_decay=0.002025342012343))
    variants.append(Hyperparameters(name='DARTS-0th-norm', **common_defs, update='liu-0th', alpha_scheduler='none',
                                    mirror_descent=False, project=False, decay_entropy=False, norm='DARTS',
                                    fuse=False, alpha_optimizer='Adam', alpha_lr=0.00516578191946,
                                    alpha_warmup=True, param_lr=0.009074790130092, weight_decay=0.000154312816))
    # Bring older stuff back:
    variants.append(Hyperparameters(name='BinaryConnect', **common_defs, update='binary-connect', norm='none',
                                    alpha_scheduler='linear', mirror_descent=False, project=False, decay_entropy=False,
                                    fuse=False, alpha_optimizer='Adam', alpha_lr=0.00722498338156,
                                    alpha_warmup=True, param_lr=0.000900649365077, weight_decay=0.000715572063514))
    variants.append(Hyperparameters(name='DARTS-2nd', **common_defs, update='higher', norm='none',
                                    alpha_scheduler='linear', mirror_descent=False, project=False, decay_entropy=False,
                                    fuse=False, alpha_optimizer='Adam', alpha_lr=0.00555700832767,
                                    alpha_warmup=True, param_lr=0.005295173554338, weight_decay=0.000325816717722))
    variants.append(Hyperparameters(name='DARTS-2nd-norm', **common_defs, update='higher', norm='DARTS',
                                    alpha_scheduler='linear', mirror_descent=False, project=False, decay_entropy=False,
                                    fuse=False, alpha_optimizer='Adam', alpha_lr=0.009512700208181,
                                    alpha_warmup=True, param_lr=0.008423877044441, weight_decay=0.000487061558992))

    return variants
