# Code for the experiments in Appendix Section B for the Blur data formation for the sequential search space from Section 3.1.1

# Setup:
dataset=Blur
layers=10
runs=10
noise=10


#############################################
# Figure 7 (left)
for variant in DARTS_1 DARTS_1_single; do
  for j in $(eval echo "{0..$runs}"); do
    for op in all-learnable; do
        python search_IP_NAS.py --variant $variant --channels 64 --cell_steps 1 --dataset $dataset --layers $layers --operations $op --exp_name automl_init_c64l$layers$noise --noise_level 0.$noise --config_path configs/DARTS_1_single_Blur_configspace_all-learnable_10.json
    done
  done
done



# Figure 7 (right)
variant=DARTS_1 
for j in $(eval echo "{0..$runs}"); do
    for op in all-learnable; do
        python search_IP_NAS.py --variant $variant --channels 64 --cell_steps 1 --dataset $dataset --layers $layers --operations $op --exp_name automl_init_bohb_blur_c64l$layers$noise --noise_level 0.$noise --config_path configs/DARTS_1_Blur_configspace_all-learnable_10.json
    done
done

# The following code is the same as for Figure 7 (left) for the Single-level optimization 
variant=DARTS_1_single; 
for j in $(eval echo "{0..$runs}"); do
    for op in all-learnable; do
        python search_IP_NAS.py --variant $variant --channels 64 --cell_steps 1 --dataset $dataset --layers $layers --operations $op --exp_name automl_init_bohb_blur_single_c64l$layers$noise --noise_level 0.$noise --config_path configs/DARTS_1_single_Blur_configspace_all-learnable_10.json
    done
done



