## Installation
Since we integrated several repos in this project, we need to build independent conda environments to reproduce our experiments.
We will illustrate these environments in the following parts.

Please note that all the links are changed into anonymous mode.

## Env1. 
The first environment is for WSOD0, segment-anything and WeakTr. If you found not compatible, please refer to the original repos for more instructions.
### Requirements:
- Python 3.8
- Pytorch 1.8.1
- Torchvision 0.9.1
- numpy 1.24.3

### Getting Started:
```bash
# Creating current conda environment
conda create -n WeakSAM python==3.8
conda activate WeakSAM

# WSOD1 dependencies
pip install ninja yacs cython matplotlib tqdm opencv-python tensorboardX pycocotools

# installing pytorch using conda, and we here utilizing CUDA 11.1 as an example. If you change the CUDA version, please refer to the original repos for more instructions.
conda install pytorch==1.8.1 torchvision==0.9.1 torchaudio==0.8.1 cudatoolkit=11.1 -c pytorch -c conda-forge

# opening the contents.
cd WeakSAM/baselines/WSOD1

# building apex for WSOD1
# please do it yourself since no available links provided.
cd apex
pip install -v --disable-pip-version-check --no-cache-dir --no-build-isolation --global-option="--cpp_ext" --global-option="--cuda_ext" ./
cd ../


python setup.py build develop

# building segment-anything dependency.
cd ../../roi_generation/segment-anything
pip install -e .
pip install opencv-python pycocotools matplotlib onnxruntime onnx

cd ../WeakTr
pip install -r requirements.txt
```


## Env2.
This environment is for WSOD0 and FSOD1(detectron2).
### Requirements
- Python 3.7
- Pytorch 1.7.0
- Torchvision 0.8.0

### Getting started
```bash
# Creating environment
conda create -n wsod0 python==3.7.0
conda activate wsod0

cd WeakSAM/baselines/WSOD0

# building requirements for mmdet
pip install -r requirements.txt

# installing pytorch1.7.0 with CUDA 11.0 and mmcv-full 1.2.6
# installing mmdet
python setup.py install

cd ../../retraining/FSOD1/detectron2
# installing detectron2 for retraining.
python3 -m pip install -v -e .
```






