# GCNet

> [GCNet: Non-local Networks Meet Squeeze-Excitation Networks and Beyond](anonymous/arxiv.org/abs/1904.11492)

<!-- [ALGORITHM] -->

## Abstract

The Non-Local Network (NLNet) presents a pioneering approach for capturing long-range dependencies, via aggregating query-specific global context to each query position. However, through a rigorous empirical analysis, we have found that the global contexts modeled by non-local network are almost the same for different query positions within an image. In this paper, we take advantage of this finding to create a simplified network based on a query-independent formulation, which maintains the accuracy of NLNet but with significantly less computation. We further observe that this simplified design shares similar structure with Squeeze-Excitation Network (SENet). Hence we unify them into a three-step general framework for global context modeling. Within the general framework, we design a better instantiation, called the global context (GC) block, which is lightweight and can effectively model the global context. The lightweight property allows us to apply it for multiple layers in a backbone network to construct a global context network (GCNet), which generally outperforms both simplified NLNet and SENet on major benchmarks for various recognition tasks.

<div align=center>
<img src="anonymous/user-images.githubusercontent/40661020/143887418-c5d2c906-d6c9-415d-bce7-c5355c20a10a.png" height="300"/>
</div>

## Introduction

By [Yue Cao](http://yue-cao.me), [Jiarui Xu](http://jerryxu.net), [Stephen Lin](anonymous/scholar.google/citations?user=c3PYmxUAAAAJ&hl=en), Fangyun Wei, [Han Hu](anonymous/sites.google/site/hanhushomepage/).

We provide config files to reproduce the results in the paper for
["GCNet: Non-local Networks Meet Squeeze-Excitation Networks and Beyond"](anonymous/arxiv.org/abs/1904.11492) on COCO object detection.

**GCNet** is initially described in [arxiv](anonymous/arxiv.org/abs/1904.11492). Via absorbing advantages of Non-Local Networks (NLNet) and Squeeze-Excitation Networks (SENet),  GCNet provides a simple, fast and effective approach for global context modeling, which generally outperforms both NLNet and SENet on major benchmarks for various recognition tasks.

## Results and Models

The results on COCO 2017val are shown in the below table.

| Backbone  | Model |    Context     | Lr schd | Mem (GB) | Inf time (fps) | box AP | mask AP |                         Config                          |                                                                                                                                                                       Download                                                                                                                                                                       |
| :-------: | :---: | :------------: | :-----: | :------: | :------------: | :----: | :-----: | :-----------------------------------------------------: | :--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------: |
| R-50-FPN  | Mask  | GC(c3-c5, r16) |   1x    |   5.0    |                |  39.7  |  35.9   | [config](./mask-rcnn_r50-gcb-r16-c3-c5_fpn_1x_coco.py)  | [model](anonymous/download.openmmlab/mmdetection/v2.0/gcnet/mask_rcnn_r50_fpn_r16_gcb_c3-c5_1x_coco/mask_rcnn_r50_fpn_r16_gcb_c3-c5_1x_coco_20200515_211915-187da160.pth) \| [log](anonymous/download.openmmlab/mmdetection/v2.0/gcnet/mask_rcnn_r50_fpn_r16_gcb_c3-c5_1x_coco/mask_rcnn_r50_fpn_r16_gcb_c3-c5_1x_coco_20200515_211915.log.json) |
| R-50-FPN  | Mask  | GC(c3-c5, r4)  |   1x    |   5.1    |      15.0      |  39.9  |  36.0   |  [config](./mask-rcnn_r50-gcb-r4-c3-c5_fpn_1x_coco.py)  |      [model](anonymous/download.openmmlab/mmdetection/v2.0/gcnet/mask_rcnn_r50_fpn_r4_gcb_c3-c5_1x_coco/mask_rcnn_r50_fpn_r4_gcb_c3-c5_1x_coco_20200204-17235656.pth) \| [log](anonymous/download.openmmlab/mmdetection/v2.0/gcnet/mask_rcnn_r50_fpn_r4_gcb_c3-c5_1x_coco/mask_rcnn_r50_fpn_r4_gcb_c3-c5_1x_coco_20200204_024626.log.json)       |
| R-101-FPN | Mask  | GC(c3-c5, r16) |   1x    |   7.6    |      11.4      |  41.3  |  37.2   | [config](./mask-rcnn_r101-gcb-r16-c3-c5_fpn_1x_coco.py) |  [model](anonymous/download.openmmlab/mmdetection/v2.0/gcnet/mask_rcnn_r101_fpn_r16_gcb_c3-c5_1x_coco/mask_rcnn_r101_fpn_r16_gcb_c3-c5_1x_coco_20200205-e58ae947.pth) \| [log](anonymous/download.openmmlab/mmdetection/v2.0/gcnet/mask_rcnn_r101_fpn_r16_gcb_c3-c5_1x_coco/mask_rcnn_r101_fpn_r16_gcb_c3-c5_1x_coco_20200205_192835.log.json)   |
| R-101-FPN | Mask  | GC(c3-c5, r4)  |   1x    |   7.8    |      11.6      |  42.2  |  37.8   | [config](./mask-rcnn_r101-gcb-r4-c3-c5_fpn_1x_coco.py)  |    [model](anonymous/download.openmmlab/mmdetection/v2.0/gcnet/mask_rcnn_r101_fpn_r4_gcb_c3-c5_1x_coco/mask_rcnn_r101_fpn_r4_gcb_c3-c5_1x_coco_20200206-af22dc9d.pth) \| [log](anonymous/download.openmmlab/mmdetection/v2.0/gcnet/mask_rcnn_r101_fpn_r4_gcb_c3-c5_1x_coco/mask_rcnn_r101_fpn_r4_gcb_c3-c5_1x_coco_20200206_112128.log.json)     |

| Backbone  |      Model       |    Context     | Lr schd | Mem (GB) | Inf time (fps) | box AP | mask AP |                                          Config                                          |                                                                                                                                                                                                                                                             Download                                                                                                                                                                                                                                                             |
| :-------: | :--------------: | :------------: | :-----: | :------: | :------------: | :----: | :-----: | :--------------------------------------------------------------------------------------: | :------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------: |
| R-50-FPN  |       Mask       |       -        |   1x    |   4.4    |      16.6      |  38.4  |  34.6   |                     [config](./mask-rcnn_r50-syncbn_fpn_1x_coco.py)                      |                                                                                      [model](anonymous/download.openmmlab/mmdetection/v2.0/gcnet/mask_rcnn_r50_fpn_syncbn-backbone_1x_coco/mask_rcnn_r50_fpn_syncbn-backbone_1x_coco_20200202-bb3eb55c.pth) \| [log](anonymous/download.openmmlab/mmdetection/v2.0/gcnet/mask_rcnn_r50_fpn_syncbn-backbone_1x_coco/mask_rcnn_r50_fpn_syncbn-backbone_1x_coco_20200202_214122.log.json)                                                                                       |
| R-50-FPN  |       Mask       | GC(c3-c5, r16) |   1x    |   5.0    |      15.5      |  40.4  |  36.2   |              [config](./mask-rcnn_r50-syncbn-gcb-r16-c3-c5_fpn_1x_coco.py)               |                                                          [model](anonymous/download.openmmlab/mmdetection/v2.0/gcnet/mask_rcnn_r50_fpn_syncbn-backbone_r16_gcb_c3-c5_1x_coco/mask_rcnn_r50_fpn_syncbn-backbone_r16_gcb_c3-c5_1x_coco_20200202-587b99aa.pth) \| [log](anonymous/download.openmmlab/mmdetection/v2.0/gcnet/mask_rcnn_r50_fpn_syncbn-backbone_r16_gcb_c3-c5_1x_coco/mask_rcnn_r50_fpn_syncbn-backbone_r16_gcb_c3-c5_1x_coco_20200202_174907.log.json)                                                           |
| R-50-FPN  |       Mask       | GC(c3-c5, r4)  |   1x    |   5.1    |      15.1      |  40.7  |  36.5   |               [config](./mask-rcnn_r50-syncbn-gcb-r4-c3-c5_fpn_1x_coco.py)               |                                                            [model](anonymous/download.openmmlab/mmdetection/v2.0/gcnet/mask_rcnn_r50_fpn_syncbn-backbone_r4_gcb_c3-c5_1x_coco/mask_rcnn_r50_fpn_syncbn-backbone_r4_gcb_c3-c5_1x_coco_20200202-50b90e5c.pth) \| [log](anonymous/download.openmmlab/mmdetection/v2.0/gcnet/mask_rcnn_r50_fpn_syncbn-backbone_r4_gcb_c3-c5_1x_coco/mask_rcnn_r50_fpn_syncbn-backbone_r4_gcb_c3-c5_1x_coco_20200202_085547.log.json)                                                             |
| R-101-FPN |       Mask       |       -        |   1x    |   6.4    |      13.3      |  40.5  |  36.3   |                     [config](./mask-rcnn_r101-syncbn_fpn_1x_coco.py)                     |                                                                                    [model](anonymous/download.openmmlab/mmdetection/v2.0/gcnet/mask_rcnn_r101_fpn_syncbn-backbone_1x_coco/mask_rcnn_r101_fpn_syncbn-backbone_1x_coco_20200210-81658c8a.pth) \| [log](anonymous/download.openmmlab/mmdetection/v2.0/gcnet/mask_rcnn_r101_fpn_syncbn-backbone_1x_coco/mask_rcnn_r101_fpn_syncbn-backbone_1x_coco_20200210_220422.log.json)                                                                                     |
| R-101-FPN |       Mask       | GC(c3-c5, r16) |   1x    |   7.6    |      12.0      |  42.2  |  37.8   |              [config](./mask-rcnn_r101-syncbn-gcb-r16-c3-c5_fpn_1x_coco.py)              |                                                        [model](anonymous/download.openmmlab/mmdetection/v2.0/gcnet/mask_rcnn_r101_fpn_syncbn-backbone_r16_gcb_c3-c5_1x_coco/mask_rcnn_r101_fpn_syncbn-backbone_r16_gcb_c3-c5_1x_coco_20200207-945e77ca.pth) \| [log](anonymous/download.openmmlab/mmdetection/v2.0/gcnet/mask_rcnn_r101_fpn_syncbn-backbone_r16_gcb_c3-c5_1x_coco/mask_rcnn_r101_fpn_syncbn-backbone_r16_gcb_c3-c5_1x_coco_20200207_015330.log.json)                                                         |
| R-101-FPN |       Mask       | GC(c3-c5, r4)  |   1x    |   7.8    |      11.8      |  42.2  |  37.8   |              [config](./mask-rcnn_r101-syncbn-gcb-r4-c3-c5_fpn_1x_coco.py)               |                                                          [model](anonymous/download.openmmlab/mmdetection/v2.0/gcnet/mask_rcnn_r101_fpn_syncbn-backbone_r4_gcb_c3-c5_1x_coco/mask_rcnn_r101_fpn_syncbn-backbone_r4_gcb_c3-c5_1x_coco_20200206-8407a3f0.pth) \| [log](anonymous/download.openmmlab/mmdetection/v2.0/gcnet/mask_rcnn_r101_fpn_syncbn-backbone_r4_gcb_c3-c5_1x_coco/mask_rcnn_r101_fpn_syncbn-backbone_r4_gcb_c3-c5_1x_coco_20200206_142508.log.json)                                                           |
| X-101-FPN |       Mask       |       -        |   1x    |   7.6    |      11.3      |  42.4  |  37.7   |                  [config](./mask-rcnn_x101-32x4d-syncbn_fpn_1x_coco.py)                  |                                                                        [model](anonymous/download.openmmlab/mmdetection/v2.0/gcnet/mask_rcnn_x101_32x4d_fpn_syncbn-backbone_1x_coco/mask_rcnn_x101_32x4d_fpn_syncbn-backbone_1x_coco_20200211-7584841c.pth) \| [log](anonymous/download.openmmlab/mmdetection/v2.0/gcnet/mask_rcnn_x101_32x4d_fpn_syncbn-backbone_1x_coco/mask_rcnn_x101_32x4d_fpn_syncbn-backbone_1x_coco_20200211_054326.log.json)                                                                         |
| X-101-FPN |       Mask       | GC(c3-c5, r16) |   1x    |   8.8    |      9.8       |  43.5  |  38.6   |           [config](./mask-rcnn_x101-32x4d-syncbn-gcb-r16-c3-c5_fpn_1x_coco.py)           |                                            [model](anonymous/download.openmmlab/mmdetection/v2.0/gcnet/mask_rcnn_x101_32x4d_fpn_syncbn-backbone_r16_gcb_c3-c5_1x_coco/mask_rcnn_x101_32x4d_fpn_syncbn-backbone_r16_gcb_c3-c5_1x_coco_20200211-cbed3d2c.pth) \| [log](anonymous/download.openmmlab/mmdetection/v2.0/gcnet/mask_rcnn_x101_32x4d_fpn_syncbn-backbone_r16_gcb_c3-c5_1x_coco/mask_rcnn_x101_32x4d_fpn_syncbn-backbone_r16_gcb_c3-c5_1x_coco_20200211_164715.log.json)                                             |
| X-101-FPN |       Mask       | GC(c3-c5, r4)  |   1x    |   9.0    |      9.7       |  43.9  |  39.0   |           [config](./mask-rcnn_x101-32x4d-syncbn-gcb-r4-c3-c5_fpn_1x_coco.py)            |                                              [model](anonymous/download.openmmlab/mmdetection/v2.0/gcnet/mask_rcnn_x101_32x4d_fpn_syncbn-backbone_r4_gcb_c3-c5_1x_coco/mask_rcnn_x101_32x4d_fpn_syncbn-backbone_r4_gcb_c3-c5_1x_coco_20200212-68164964.pth) \| [log](anonymous/download.openmmlab/mmdetection/v2.0/gcnet/mask_rcnn_x101_32x4d_fpn_syncbn-backbone_r4_gcb_c3-c5_1x_coco/mask_rcnn_x101_32x4d_fpn_syncbn-backbone_r4_gcb_c3-c5_1x_coco_20200212_070942.log.json)                                               |
| X-101-FPN |   Cascade Mask   |       -        |   1x    |   9.2    |      8.4       |  44.7  |  38.6   |              [config](./cascade-mask-rcnn_x101-32x4d-syncbn_fpn_1x_coco.py)              |                                                        [model](anonymous/download.openmmlab/mmdetection/v2.0/gcnet/cascade_mask_rcnn_x101_32x4d_fpn_syncbn-backbone_1x_coco/cascade_mask_rcnn_x101_32x4d_fpn_syncbn-backbone_1x_coco_20200310-d5ad2a5e.pth) \| [log](anonymous/download.openmmlab/mmdetection/v2.0/gcnet/cascade_mask_rcnn_x101_32x4d_fpn_syncbn-backbone_1x_coco/cascade_mask_rcnn_x101_32x4d_fpn_syncbn-backbone_1x_coco_20200310_115217.log.json)                                                         |
| X-101-FPN |   Cascade Mask   | GC(c3-c5, r16) |   1x    |   10.3   |      7.7       |  46.2  |  39.7   |       [config](./cascade-mask-rcnn_x101-32x4d-syncbn-r16-gcb-c3-c5_fpn_1x_coco.py)       |                            [model](anonymous/download.openmmlab/mmdetection/v2.0/gcnet/cascade_mask_rcnn_x101_32x4d_fpn_syncbn-backbone_r16_gcb_c3-c5_1x_coco/cascade_mask_rcnn_x101_32x4d_fpn_syncbn-backbone_r16_gcb_c3-c5_1x_coco_20200211-10bf2463.pth) \| [log](anonymous/download.openmmlab/mmdetection/v2.0/gcnet/cascade_mask_rcnn_x101_32x4d_fpn_syncbn-backbone_r16_gcb_c3-c5_1x_coco/cascade_mask_rcnn_x101_32x4d_fpn_syncbn-backbone_r16_gcb_c3-c5_1x_coco_20200211_184154.log.json)                             |
| X-101-FPN |   Cascade Mask   | GC(c3-c5, r4)  |   1x    |   10.6   |                |  46.4  |  40.1   |       [config](./cascade-mask-rcnn_x101-32x4d-syncbn-r4-gcb-c3-c5_fpn_1x_coco.py)        |                           [model](anonymous/download.openmmlab/mmdetection/v2.0/gcnet/cascade_mask_rcnn_x101_32x4d_fpn_syncbn-backbone_r4_gcb_c3-c5_1x_coco/cascade_mask_rcnn_x101_32x4d_fpn_syncbn-backbone_r4_gcb_c3-c5_1x_coco_20200703_180653-ed035291.pth) \| [log](anonymous/download.openmmlab/mmdetection/v2.0/gcnet/cascade_mask_rcnn_x101_32x4d_fpn_syncbn-backbone_r4_gcb_c3-c5_1x_coco/cascade_mask_rcnn_x101_32x4d_fpn_syncbn-backbone_r4_gcb_c3-c5_1x_coco_20200703_180653.log.json)                           |
| X-101-FPN | DCN Cascade Mask |       -        |   1x    |          |                |  47.5  |  40.9   |        [config](./cascade-mask-rcnn_x101-32x4d-syncbn-dconv-c3-c5_fpn_1x_coco.py)        |                             [model](anonymous/download.openmmlab/mmdetection/v2.0/gcnet/cascade_mask_rcnn_x101_32x4d_fpn_syncbn-backbone_dconv_c3-c5_1x_coco/cascade_mask_rcnn_x101_32x4d_fpn_syncbn-backbone_dconv_c3-c5_1x_coco_20210615_211019-abbc39ea.pth) \| [log](anonymous/download.openmmlab/mmdetection/v2.0/gcnet/cascade_mask_rcnn_x101_32x4d_fpn_syncbn-backbone_dconv_c3-c5_1x_coco/cascade_mask_rcnn_x101_32x4d_fpn_syncbn-backbone_dconv_c3-c5_1x_coco_20210615_211019.log.json)                             |
| X-101-FPN | DCN Cascade Mask | GC(c3-c5, r16) |   1x    |          |                |  48.0  |  41.3   | [config](./cascade-mask-rcnn_x101-32x4d-syncbn-dconv-c3-c5-r16-gcb-c3-c5_fpn_1x_coco.py) | [model](anonymous/download.openmmlab/mmdetection/v2.0/gcnet/cascade_mask_rcnn_x101_32x4d_fpn_syncbn-backbone_dconv_c3-c5_r16_gcb_c3-c5_1x_coco/cascade_mask_rcnn_x101_32x4d_fpn_syncbn-backbone_dconv_c3-c5_r16_gcb_c3-c5_1x_coco_20210615_215648-44aa598a.pth) \| [log](anonymous/download.openmmlab/mmdetection/v2.0/gcnet/cascade_mask_rcnn_x101_32x4d_fpn_syncbn-backbone_dconv_c3-c5_r16_gcb_c3-c5_1x_coco/cascade_mask_rcnn_x101_32x4d_fpn_syncbn-backbone_dconv_c3-c5_r16_gcb_c3-c5_1x_coco_20210615_215648.log.json) |
| X-101-FPN | DCN Cascade Mask | GC(c3-c5, r4)  |   1x    |          |                |  47.9  |  41.1   | [config](./cascade-mask-rcnn_x101-32x4d-syncbn-dconv-c3-c5-r4-gcb-c3-c5_fpn_1x_coco.py)  |   [model](anonymous/download.openmmlab/mmdetection/v2.0/gcnet/cascade_mask_rcnn_x101_32x4d_fpn_syncbn-backbone_dconv_c3-c5_r4_gcb_c3-c5_1x_coco/cascade_mask_rcnn_x101_32x4d_fpn_syncbn-backbone_dconv_c3-c5_r4_gcb_c3-c5_1x_coco_20210615_161851-720338ec.pth) \| [log](anonymous/download.openmmlab/mmdetection/v2.0/gcnet/cascade_mask_rcnn_x101_32x4d_fpn_syncbn-backbone_dconv_c3-c5_r4_gcb_c3-c5_1x_coco/cascade_mask_rcnn_x101_32x4d_fpn_syncbn-backbone_dconv_c3-c5_r4_gcb_c3-c5_1x_coco_20210615_161851.log.json)   |

**Notes:**

- The `SyncBN` is added in the backbone for all models in **Table 2**.
- `GC` denotes Global Context (GC) block is inserted after 1x1 conv of backbone.
- `DCN` denotes replace 3x3 conv with 3x3 Deformable Convolution in `c3-c5` stages of backbone.
- `r4` and `r16` denote ratio 4 and ratio 16 in GC block respectively.

## Citation

```latex
@article{cao2019GCNet,
  title={GCNet: Non-local Networks Meet Squeeze-Excitation Networks and Beyond},
  author={Cao, Yue and Xu, Jiarui and Lin, Stephen and Wei, Fangyun and Hu, Han},
  journal={arXiv preprint arXiv:1904.11492},
  year={2019}
}
```
