# Data Reweighting for Pre-training

## Introduction
Pretraining/finetuning frameworks are getting popularized with the recent advancement in
self-supervised learning.
However, pretraining data are oftentimes from a different distribution than finetuning data,
which could potentially cause negative transfer.
To overcome this issue,
[Meta-Learning to Improve Pre-TrainingMeta-learning](https://arxiv.org/abs/2111.01754)
combines a data reweighting scheme with
pretraining/finetuning frameworks to automatically suppress the weight of pretraining data samples
that cause negative transfer while increasing the weight of others.

## Dataset
The OfficeHome dataset can be downloaded via this [link](http://155.33.198.138/lbi_data.zip).

## Environment
Our code is developed/tested on:

- Python 3.8.10
- pytorch 1.10
- torchvision 1.11

## Scripts
Baseline:
```
python main.py --gpu=0 --source_domain=Cl --target_domain=Ar --lam=7e-3 --baseline
```
Learning by Ignoring:
```
python main.py --gpu=0 --source_domain=Cl --target_domain=Ar --lam=7e-3
```
Run all experiments:
```
bash run.sh
```
