# Experiments

Select algorithms by ALG_ID, environments by ENV_ID, and GPU by GPU_ID.

## Command for PPO and PPO + H: *PPO_H.py*

Command to run *PPO_H.py*:

``` python PPO_H.py #GPU_ID #ALG_ID #ENV_ID ```

For example, train *PPO+H* on *Hopper-v3* on *GPU 0* by

```python PPO_H.py 0 1 0``` 

| Algorithm            | ALG_ID    |
| -----------      | ----------- |
| PPO              | 0           |
| PPO + H          | 1           |

| Environment      | ENV_ID      |
| -----------      | ----------- |
| Hopper-v3        | 0           |
| Swimmer-v3       | 1           |
| Ant-v3           | 2           |
| Humanoid-v3      | 3           |
| HalfCheetah-v3   | 4           |
| Walker2D-v3      | 5           |




## Comand for DDPG and DDPG + H: *DDPG_H.py*

Command to run *DDPG_H.py*:

``` python DDPG_H.py #GPU_ID #ALG_ID #ENV_ID ```

For example, train *DDPG + H* on *Hopper-v3* on *GPU 0* by

```python DDPG_H.py 0 1 0``` 

| Algorithm            | ALG_ID    |
| -----------      | ----------- |
| DDPG             | 0           |
| DDPG + H         | 1           |


| Environment      | ENV_ID      |
| -----------      | ----------- |
| Hopper-v3        | 0           |
| Swimmer-v3       | 1           |
| Ant-v3           | 2           |
| Humanoid-v3      | 3           |
| HalfCheetah-v3   | 4           |
| Walker2D-v3      | 5           |
