This is an unofficial re-implementation of Distral (discrete action space).

Please refer to https://github.com/Alfo5123/Robust-Multitask-RL for the original code.

Major differences are:

- code structure (separated into directories, removed result files)
- network architecture (increased capacity)
- new environment (reacher multistage)

Distral codes are in [agents/distral_1col0](agents/distral_1col0) (for 1-column) and [agents/distral_2col0](agents/distral_2col0) (for 2-column).

Codes for running them are [distral_reacher_1col.py](distral_reacher_1col.py) and [distral_reacher_2col.py](distral_reacher_2col.py), respectively.

# Robust-Multitask-RL

 Machine Learning Course Project Skoltech 2018
 
 We implemented the Distral algorithm and replicated the results obtained in the recent Google DeepMind's paper: *"Distral: Robust Multitask Reinforcement Learning"*
 
![alt text](https://github.com/Alfo5123/Robust-Multitask-RL/blob/master/code/experiments/ANIMATIONS/457.gif "Distral1")

## Authors

* **Anastasia Koloskova** 
* **Alfredo de la Fuente** 
 
## Resources & References

Papers:

- [Distral: Robust Multitask Reinforcement Learning](https://arxiv.org/pdf/1707.04175.pdf)
- [Actor-Mimic: Deep Multitask and Transfer Reinforcement Learning](https://arxiv.org/abs/1511.06342)
- [Reinforcement Learning with Deep Energy-Based Policies](https://arxiv.org/pdf/1702.08165.pdf)
- [Asynchronous Methods for Deep Reinforcement Learning](https://arxiv.org/pdf/1602.01783.pdf)
- [Equivalence Between Policy Gradients and Soft Q-Learning](https://arxiv.org/pdf/1704.06440.pdf)
- [Policy Gradient Methods for Reinforcement Learning with Function Approximation](https://papers.nips.cc/paper/1713-policy-gradient-methods-for-reinforcement-learning-with-function-approximation.pdf)

Textbooks:

- [Reinforcement Learning: An Introduction (2nd Edition)](http://incompleteideas.net/book/bookdraft2018jan1.pdf)

Classes:

- [David Silver's Reinforcement Learning Course (UCL, 2015)](http://www0.cs.ucl.ac.uk/staff/d.silver/web/Teaching.html)
- [CS294 - Deep Reinforcement Learning (Berkeley, Fall 2015)](http://rll.berkeley.edu/deeprlcourse/)

Repositories: 

- [Denny Britz's reinforcement learning compilation of algorithms and material](https://github.com/dennybritz/reinforcement-learning)
- [OpenAI Gym](https://github.com/openai/gym)



