from unsloth import FastLanguageModel, FastModel
import torch
from trl import SFTTrainer, SFTConfig
from datasets import load_dataset
import functools
from typing import Dict, Any
from unsloth.chat_templates import get_chat_template
from transformers import DataCollatorForSeq2Seq

max_seq_length = 2048 # Supports RoPE Scaling internally, so choose any!
# Get LAION dataset
# url = "https://huggingface.co/datasets/laion/OIG/resolve/main/unified_chip2.jsonl"
# dataset = load_dataset("json", data_files = {"train" : url}, split = "train")

random_path = ""
api_path = ""
cluster_path = ""
distillation_path = ""
stein_pure_path = ""
main_path=""

def fine_tune(data_path,data_type,shuffle,model_name,chat_template,train_batch_size=16,warmup=3,num_epoch=0.3,learning_rate=1e-5,max_step=10):
    dataset = load_dataset("csv",data_files=data_path)
    dataset=dataset["train"]
    if shuffle:
        dataset = dataset.shuffle(seed=44).select(range(500))
    print(len(dataset))
    max_seq_length = 2048 # Choose any! We auto support RoPE Scaling internally!
    dtype = None # None for auto detection. Float16 for Tesla T4, V100, Bfloat16 for Ampere+
    load_in_4bit = True # Use 4bit quantization to reduce memory usage. Can be False.
    # 4bit pre quantized models we support for 4x faster downloading + no OOMs.

    model, tokenizer = FastLanguageModel.from_pretrained(
        # model_name = "google/gemma-2-9b-it",
        model_name = model_name,
        max_seq_length = max_seq_length,
        dtype = dtype,
        load_in_4bit = load_in_4bit,
        token = "", # use one if using gated models like meta-llama/Llama-2-7b-hf
    )

    model = FastLanguageModel.get_peft_model(
        model,
        r = 16, # Choose any number > 0 ! Suggested 8, 16, 32, 64, 128
        target_modules = ["q_proj", "k_proj", "v_proj", "o_proj",
                        "gate_proj", "up_proj", "down_proj",],
        lora_alpha = 16,
        lora_dropout = 0, # Supports any, but = 0 is optimized
        bias = "none",    # Supports any, but = "none" is optimized
        # [NEW] "unsloth" uses 30% less VRAM, fits 2x larger batch sizes!
        use_gradient_checkpointing = "unsloth", # True or "unsloth" for very long context
        random_state = 3407,
        use_rslora = False,  # We support rank stabilized LoRA
        loftq_config = None, # And LoftQ
    )

    tokenizer = get_chat_template(
        tokenizer,
        chat_template = chat_template,
    )
    def formatting_prompts_func(example):
        """Format the example to include the question and answer in the text field."""
        prompt = example['question']
        answer = example['answer']
        if prompt is None:
            prompt="Sorry, please repeat the question"
        if answer is None:
            answer="Sorry, I can't answer this"
        print(prompt)
        print("\n")
        print(answer)
        chat = [
            {"role": "system", "content": "You are a helpful assistant."},
            {'role': 'user', 'content': prompt},
            {'role': 'assistant', 'content': answer}
        ]
        texts = tokenizer.apply_chat_template(chat, tokenize = False, add_generation_prompt = False)
        return {'text': texts}

    pass

    dataset = dataset.map(formatting_prompts_func)

    train_batch_size=train_batch_size
    warmup=int(max_step/4)
    num_epoch=num_epoch
    learning_rate=learning_rate


    trainer = SFTTrainer(
        model = model,
        tokenizer = tokenizer,
        train_dataset = dataset,
        dataset_text_field = "text",
        max_seq_length = max_seq_length,
        data_collator = DataCollatorForSeq2Seq(tokenizer = tokenizer),
        packing = False, # Can make training 5x faster for short sequences.
        args = SFTConfig(
            per_device_train_batch_size = train_batch_size,
            gradient_accumulation_steps = 1,
            warmup_steps = warmup,
            # num_train_epochs = num_epoch, # Set this for 1 full training run.
            max_steps = max_step,
            learning_rate = learning_rate,
            logging_steps = 1,
            optim = "adamw_8bit",
            weight_decay = 0.01,
            lr_scheduler_type = "linear",
            seed = 3407,
            output_dir = "outputs",
            report_to = "none", # Use this for WandB etc
        ),
    ) 
    trainer.train()
    save_path = "./model_results/" + model_name + \
    "-gsm8k500" + data_type + "_bsize{bs}_wp{wp}_nep{nep}_lr{lr}_ms{ms}".format(bs=train_batch_size,
                                                                       wp=warmup,
                                                                       nep=num_epoch,
                                                                       lr=learning_rate,
                                                                       ms=max_step)
    model.save_pretrained(save_path)
    tokenizer.save_pretrained(save_path)

                    
for bs in [64,128]:
    for wp in [10]:
        for nep in [1]:
            for lr in [1e-4,1e-5,5e-6]:
                for ms in [5,10,16,20,50]:
                    for path in [main_path]:
                        if "api" in path:
                            dt = "A"
                        elif "cluster" in path:
                            dt = "C"
                        elif "random" in path:
                            dt = "R"
                        elif "gpt-3.5" in path:
                            dt = "D"
                        elif "Steinpure" in path:
                            dt = "S"
                        print(dt)
                        fine_tune(data_path=path,
                                data_type=dt,
                                shuffle=False,
                                model_name="meta-llama/Llama-3.1-8B-Instruct",   #"google/gemma-2-9b-it", "meta-llama/Llama-3.1-8B-Instruct", "microsoft/Phi-3.5-mini-instruct"
                                chat_template="llama-3.1",       #"gemma2_chatml", "llama-3.1", "phi-3.5"
                                train_batch_size=bs,
                                warmup=wp,
                                num_epoch=nep,
                                learning_rate=lr,
                                max_step=ms)