import transformers
from experiments import experiment_from_args
from run_args import DataArguments, ModelArguments, TrainingArguments
import pdb
import multiprocessing as mp
import nltk
nltk.download('punkt')
nltk.download('punkt_tab')


def main():
    parser = transformers.HfArgumentParser(
        (ModelArguments, DataArguments, TrainingArguments)
    )
    model_args, data_args, training_args = parser.parse_args_into_dataclasses()

    experiment = experiment_from_args(model_args, data_args, training_args)

    experiment.run()


if __name__ == "__main__":
    mp.set_start_method("spawn", force=True)
    main()
