import re
import json

def extract_json_code(text) -> str:
    code_block = re.search(
        rf"```(?:json)?(.*?)```", text, flags=re.DOTALL)
    if code_block is None:
        code_block = re.search(
        rf"```(.*?)```", text, flags=re.DOTALL)
    if code_block is None:
        return text
    else:
        return code_block.group(1)

def extract_diff_code(text) -> str:
    code_block = re.search(
        rf"```(?:diff)?(.*?)```", text, flags=re.DOTALL)
    if code_block is None:
        code_block = re.search(
        rf"```(.*?)```", text, flags=re.DOTALL)
    if code_block is None:
        return text
    else:
        return code_block.group(1)
