

class PromptManager:
    def __init__(self):
        self.prompts = {
            "解决Issue": """As a coding expert, you'll be given a code repository with line numbers and an issue statement. I need you to resolve this issue by creating a single patch file that I can directly apply to this repository using 'git apply'. Please provide the solution in the form of a single patch file in the following format(using triple backticks and diff format).
```diff
--- a/file.py
+++ b/file.py
@@ -1,27 +1,35 @@
 def euclidean(a, b):
-    while b:
-        a, b = b, a % b
-    return a
+    if b == 0:
+        return a
+    return euclidean(b, a % b)
 
 
 def bresenham(x0, y0, x1, y1):
     points = []
     dx = abs(x1 - x0)
     dy = abs(y1 - y0)
-    sx = 1 if x0 < x1 else -1
-    sy = 1 if y0 < y1 else -1
-    err = dx - dy
+    x, y = x0, y0
+    sx = -1 if x0 > x1 else 1
+    sy = -1 if y0 > y1 else 1
 
-    while True:
-        points.append((x0, y0))
-        if x0 == x1 and y0 == y1:
-            break
-        e2 = 2 * err
-        if e2 > -dy:
+    if dx > dy:
+        err = dx / 2.0
+        while x != x1:
+            points.append((x, y))
             err -= dy
-            x0 += sx
-        if e2 < dx:
-            err += dx
-            y0 += sy
+            if err < 0:
+                y += sy
+                err += dx
+            x += sx
+    else:
+        err = dy / 2.0
+        while y != y1:
+            points.append((x, y))
+            err -= dx
+            if err < 0:
+                x += sx
+                err += dy
+            y += sy
 
+    points.append((x, y))
     return points
```""",
            "寻找Issue": """As a programming expert, you'll be given a code repository. Your task is to identify only one potential issues. You should return the issue's title and details directly in a JSON format, which should look like this:
```json
{
    "title": "Title of the issue",
    "description": "Content of the issue"
}
```
Here is an example of output:
```json
{
    "title": "Division by zero",
    "description": "The code contains a division by zero error in the function euclidean(a, b)\nPlease update the code to handle this case."
}
```
""",
            "解释Issue": """As a programming expert, you will be provided an issue and corresponding code base. You need to deeply analyze these information, find out the key part of the issue, and then explain the cause of the issue and the solution from the developer's perspective. Your explanation should be detailed and easy to understand, and also explain as much as possible how the commit solves the issue. When explaining, you should first summarize the issue, then detail the content of the commit, and finally explain how the commit solves the issue.
""",
            "回复Issue": """As a coding whiz, you'll be given two JSON files. One outlines the issue's title and detailed description, and the other represents the whole code repository. Your task is to respond to the issue, explaining its cause and how to solve it. Remember, you need to address the issue from a developer's perspective. Your response, which should contain the explanation, needs to be returned directly in a JSON format, like this:
```json
{"explanation": "Content of the explanation"}
```""",
            "定位Issue": """As a programming expert, you'll be given a code repository and a problem statement. Your task is to figure out which parts of the code could cause the issue. You should return a list directly, with each element being a four-part tuple representing the code's location. These tuples should include the filename, the function where the code is located, the exact code content (including context, three lines before and after the target line), and the exact code content (only including the parts that need to be modified). The format should be in JSON, like this:
```json
[
    {
        "file": "Filename where the problematic code is located",
        "function":{"The line number of the specific function": "Function where the problematic code is located"},
        "content_all": {"The line number of the specific code": "Location of the problematic code, including context, three lines before and after the target line", ...},
        "content_change": {"The line number of the specific code": "Exact content of the problematic code", ...}
    },
    {Another piece of problematic code},
    ...
]
```
Here is an exmpale of output:
```json
[
    {
        "file": "Infinidat_munch/munch/__init__.py",
        "function": {
            "511": "unmunchify_cycles"
        },
        "content_all": {
            "510": "\n",
            "511": "    def unmunchify_cycles(obj):\n",
            "512": "        # If we've already begun unmunchifying obj, just return the already-created unmunchified obj\n",
            "513": "        if id(obj) in seen.keys():\n",
            "514": "            return seen[id(obj)]\n",
            "515": "        # Otherwise, first partly unmunchify obj (but without descending into any lists or dicts) and save that\n",
            "516": "        seen[id(obj)] = partial = pre_unmunchify(obj)\n",
            "517": "        # Then finish unmunchifying lists and dicts inside obj (reusing unmunchified obj if cycles are encountered)\n"
        },
        "content_change": {
            "513": "        if id(obj) in seen.keys():\n"
        }
    },
    ...
]
```
""",
            "修改Code": """As a coding expert, you'll be given a code repository for you to enhance. You should output in JSON format, which includes one issue you identified in the original code, the solution to the issue, content of the commit message, and the patch of the commit. Note that this issue should be resolved with a commit, and the single patch file can directly apply to this repository using 'git apply'.It should look like this:
```json
{"title": "Title of the Issue", "description": "Content of the Issue", "explanation": "Explanation of the Issue and how to solve it", "commit message": "Content of the commit message", "patch": "A single patch file that resolves the Issue"}
```
""",
            "评估IssueCode": """As a coding expert, I've got a commit and a corresponding issue for you. I need you to determine whether the issue is related to the commit, and provide a relevance score (from 0 to 10, where 0 indicates no relation at all, and 10 indicates a perfect match) and a confidence level score (with 5 being the highest and 1 being the lowest). Please explain your judgement first, then return the scores in a JSON format, like this: ```json
{"Score": "Number of relevance", "Confidence": "Confidence Level"}
```""",
            "评估commit": """"You are a programming expert. I have a commit information that includes the commit message, filename, and associated patch. Could you assess the quality of this commit (give a score, 0 implies non-standard, 10 implies highly standard), for instance, whether the commit message is relevant to the commit, and the quality rating of the patch. Please provide an explanation first, then return a json format that indicates the Score and confidence level (Confidence Level with 5 as the highest and 1 as the lowest) like this:
```json
{"Score": "quality of this commit", "Confidence": "Confidence Level"}
```""",
        "评测Issue质量": """As a software engineer with over ten years of programming experience, you possess a profound familiarity with issue assessment, specifically dedicated to evaluating the quality of programming issues. You are presented with two issues, referred to as Issue_A and Issue_B, along with corresponding error messages, patches that can fix the bugs. Your task is to score the quality of Issue_B based on the following criteria:

** Reproducibility of the Issue**
- **High Score (>5)**: The issue includes a concise, step-by-step guide that anyone can follow to reproduce the problem, possibly supplemented by a script, a test case, or a link to a branch in a code repository.
- **Low Score (<5)**: Steps are either too vague, incomplete, or incorrect, making the issue difficult or impossible to reproduce.

** Relevance of the Issue**
- **High Score (>7)**: The issue clearly identifies the related bug, accurately connects it with the error message, and the patch effectively resolves this specific issue as validated through testing.
- **Medium Score (4-6 points)**: The issue identifies a related problem, but the connection between the problem and the error message is not perfectly clear. The patch partially addresses the issue or requires further modifications to fully resolve it.
- **Low Score (<4)**: The issue raised is either not directly related to a bug, or the connection between the issue and the provided error messages is weak or non-existent. The submitted patch does not effectively address a specific error message or fails to demonstrate a clear understanding of the underlying issue.

** Explanation for the Issue Solution**
- **High Score (>5)**: The explanation of the patch or solution is thorough, demonstrating a clear understanding of the problem and how the fix addresses it. The patch is also tested and validated.
- **Low Score (<5)**: The connection between the problem described in the issue and the resulting error messages is unclear or incorrect. The proposed patch may not effectively resolve the issue, or it may not be targeted appropriately. 

**  Overall
- Overall evaluation of the issue.

For comparison, Issue_A, considered as ground truth, has been rated with 8 points for each criterion. Your task is to evaluate Issue_B against these criteria, assigning scores ranging from 0 to 10 for each. The outcome of your evaluation should be documented in a JSON file, detailing the scores for each criterion for Issue_B.

Strategy for Evaluation:

1. Begin by thoroughly reading the content of both issues, understanding their problems, and familiarizing yourself with the error messages and bug-fix patches.
2. Evaluate Issue_B based on the outlined criteria, assigning scores ranging from 0 to 10 accordingly.
3. Give the reason for the point first and then document your evaluation results in a JSON file using the following format:
```json
{"Reproducibility": score, "Relevance": score, "Explanation": score, "Overall": score}
```"""
        }

    def get_prompt(self, key):
        return self.prompts[key]
