import torch
import itertools

def split_dataset(n_dim, split_ratio):
    # 가능한 모든 경우의 수를 생성합니다.
    all_combinations = torch.tensor(list(itertools.product([-1, 1], repeat=n_dim)))

    # dimension=0에 대해 랜덤 순열을 적용합니다.
    permuted_combinations = all_combinations[torch.randperm(all_combinations.size(0))]

    # split합니다.
    split_index = int(permuted_combinations.size(0) * split_ratio)

    train_set = permuted_combinations[:split_index]
    test_set = permuted_combinations[split_index:]

    splitdict = {}
    splitdict['train'] = train_set
    splitdict['test'] = test_set

    return splitdict
