
import os, sys
import argparse

sys.path.append('..')
from utils.argparse_utils import *

TRAINING_ARGS = ['is_vae', 'model', 'data_dir', 'w3j_filepath', 'neigh_kind', 'rmax', 'lmax', 'n_channels', 'rcut', 'n_train_neigh', 'n_valid_neigh', 'n_test_neigh', 'rst_normalization',
                      'get_H', 'get_SASA', 'get_charge', 'normalize', 'net_lmax', 'latent_dim', 'n_cg_blocks', 'lmax_list', 'ch_size_list', 'ls_nonlin_rule_list',
                      'ch_nonlin_rule_list', 'do_initial_linear_projection', 'ch_initial_linear_projection', 'filter_symmetric', 'use_batch_norm',
                      'linearity_first', 'norm_type', 'normalization', 'norm_balanced', 'norm_affine', 'norm_nonlinearity', 'norm_location', 'use_additive_skip_connections',
                      'weight_decay', 'x_rec_loss_fn', 'batch_size', 'learn_frame', 'lr', 'lr_schedule', 'n_epochs', 'lambdas', 'lambdas_schedule', 'no_kl_epochs', 'warmup_kl_epochs',
                      'seed', 'hash', 'experiments_dir', 'experiments_suffix', 'use_wandb', 'use_tensorboard']

if __name__ == '__main__':
    parser = argparse.ArgumentParser()

    ## training arguments
    parser.add_argument('--is_vae', type=str_to_bool, default=True)
    parser.add_argument('--model', type=str, default='cgvae_symmetric_simple_flexible')
    parser.add_argument('--data_dir', type=str, default='../data/toy_aminoacids/data')
    parser.add_argument('--w3j_filepath', type=str, default='../cg_coefficients/w3j_matrices-lmax=14-version=0.5.0.pkl')

    parser.add_argument('--neigh_kind', type=str, default='toy_aminoacids')
    parser.add_argument('--rmax', type=int, default=20)
    parser.add_argument('--lmax', type=int, default=4)
    parser.add_argument('--n_channels', type=int, default=4)
    parser.add_argument('--rcut', type=float, default=10.0)
    parser.add_argument('--n_train_neigh', type=int, default=1000)
    parser.add_argument('--n_valid_neigh', type=int, default=1000)
    parser.add_argument('--n_test_neigh', type=int, default=10000)
    parser.add_argument('--rst_normalization', type=str, default='square')
    parser.add_argument('--get_H', type=str_to_bool, default=False)
    parser.add_argument('--get_SASA', type=str_to_bool, default=False)
    parser.add_argument('--get_charge', type=str_to_bool, default=False)
    parser.add_argument('--normalize', type=optional_str, default='avg_sqrt_power')

    parser.add_argument('--net_lmax', type=int, default=4)
    parser.add_argument('--latent_dim', type=int, default=2)
    parser.add_argument('--n_cg_blocks', type=int, default=6)
    parser.add_argument('--lmax_list', type=str, default='4,4,4,4,2,1')
    parser.add_argument('--ch_size_list', type=str, default='60,40,24,16,16,8')
    parser.add_argument('--ls_nonlin_rule_list', type=str, default='efficient,efficient,efficient,efficient,efficient,efficient')
    parser.add_argument('--ch_nonlin_rule_list', type=str, default='elementwise,elementwise,elementwise,elementwise,elementwise,elementwise')
    parser.add_argument('--do_initial_linear_projection', type=str_to_bool, default=True)
    parser.add_argument('--ch_initial_linear_projection', type=int, default=60)

    parser.add_argument('--filter_symmetric', type=str_to_bool, default=True)
    parser.add_argument('--linearity_first', type=str_to_bool, default=False)

    parser.add_argument('--use_batch_norm', type=str_to_bool, default=True)
    parser.add_argument('--norm_type', type=str, default='signal') # None, layer, signal, layer_and_signal
    parser.add_argument('--normalization', type=str, default='component') # norm, component -> only considered if norm_type is not none
    parser.add_argument('--norm_balanced', type=str_to_bool_or_float, default=False)
    parser.add_argument('--norm_affine', type=str, default='per_l') # None, {True, False} -> for layer_norm, {unique, per_l, per_feature} -> for signal_norm
    parser.add_argument('--norm_nonlinearity', type=str, default=None) # identity, relu, swish, sigmoid -> only for layer_norm
    parser.add_argument('--norm_location', type=str, default='between') # first, between, last

    parser.add_argument('--use_additive_skip_connections', type=str_to_bool, default=True)
    parser.add_argument('--weight_decay', type=str_to_bool, default=False)
    parser.add_argument('--x_rec_loss_fn', type=str, default='mse')
    parser.add_argument('--batch_size', type=int, default=10)
    parser.add_argument('--learn_frame', type=str_to_bool, default=True)
    parser.add_argument('--lr', type=float, default=0.005)
    parser.add_argument('--lr_schedule', type=str, default='log_decrease_until_end_of_warmup', choices=['constant', 'log_decrease_until_end_of_warmup', 'log_decrease_until_end_by_1_OM', 'log_decrease_until_end_by_2_OM', 'linear_decrease_until_end_of_warmup', 'decrease_below_threshold', 'decrease_after_warmup', 'decrease_at_half'])
    parser.add_argument('--n_epochs', type=int, default=80)
    parser.add_argument('--lambdas', type=str, default='400.0,0.025')
    parser.add_argument('--lambdas_schedule', type=str, default='linear_up_anneal_kl', choices=['constant', 'drop_kl_at_half', 'linear_up_anneal_kl'])
    parser.add_argument('--no_kl_epochs', type=int, default=25)
    parser.add_argument('--warmup_kl_epochs', type=int, default=35)

    parser.add_argument('--seed', type=int, default=420420420)

    parser.add_argument('--hash', type=str, required=True, help='Unique identifier for the run. Usually a hash of the hyperparameters.') # cgvae_symm_simp_flex-10-lmax=4_bs=512_z=64_blocks=7
    parser.add_argument('--experiments_dir', type=str, default='../runs')
    parser.add_argument('--experiments_suffix', type=str, default='equiv_fibers')
    parser.add_argument('--use_wandb', type=str_to_bool, default=False)
    parser.add_argument('--use_tensorboard', type=str_to_bool, default=False)


    ## evaluation pipeline arguments
    parser.add_argument('--model_class', type=str, default='fibers')
    parser.add_argument('--model_dir', type=str, default='../runs/{}/local_equiv_fibers')
    parser.add_argument('--splits', type=str, default='train,valid,test')
    parser.add_argument('--model_types', type=comma_sep_str_list, default='lowest_total_loss_with_final_kl_model') # lowest_total_loss_with_final_kl_model, lowest_rec_loss
    parser.add_argument('--seed_eval', type=int, default=1000005)
    parser.add_argument('--do_training', type=str_to_bool, default=True)
    parser.add_argument('--do_inference', type=str_to_bool, default=True)

    args = parser.parse_args()

    ## launch training
    if args.do_training:
        command = 'python train_vae_aminoacids_with_fibers_simple_flexible.py'
        for arg in TRAINING_ARGS:
            command += ' --%s %s' % (arg, eval('args.%s' % arg)) # everything should format fine enough as a string
        os.system(command)

    ## call evaluation pipeline on each requested model type
    for model_type in args.model_types:
        ## call evaluation pipeline on each split separately
        command = 'python evaluation_pipeline_zernicke.py'
        command += ' --model_class %s' % (args.model_class)
        command += ' --w3j_filepath %s' % (args.w3j_filepath)
        command += ' --data_dir %s' % (args.data_dir)
        command += ' --model_dir %s' % (args.model_dir.format(args.neigh_kind))
        command += ' --splits %s' % (args.splits)
        command += ' --model_type %s' % (model_type)
        command += ' --hash %s' % (args.hash)
        command += ' --seed %d' % (args.seed_eval)
        command += ' --do_inference %s' % (args.do_inference)
        os.system(command)
    
