
import numpy as np

from typing import *

def get_list_of_combos_from_grid(grid):
    '''
    Takes as input a Dict where values are lists of possible combinations (e.g. a grid for hyperparameter search).
    Returns a List of Dicts, each containing the same keys of the input Dict, and containing a unique set
        of values among the possible combinations given by the input Dict
    '''
    keys = []
    values = []
    for key in grid:
        keys.append(key)
        values.append(grid[key])  
    list_of_permutations = [list(x) for x in np.array(np.meshgrid(*values)).T.reshape(-1,len(values))]
    
    list_of_combos = []
    for perms in list_of_permutations:
        adict = {}
        for i, value in enumerate(perms):
            adict[keys[i]] = value
        list_of_combos.append(adict)
    
    return list_of_combos