import requests
from retry import retry
import os
OPENAI_API_KEY = os.getenv("OPENAI_API_KEY")

@retry(tries=3, backoff=3, max_delay=60)
def call_llm(
    text, 
    system_prompt="You are a helpful and knowledgeable AI assistant. Provide accurate, concise, and relevant responses based on the user’s instructions. Maintain a polite and neutral tone, and do not add any information beyond what is asked.", 
    model="gpt-4.1-mini", 
    max_tokens=4096,
    temperature=0.3
):
    """
    Call OpenAI API with the given text and parameters.
    
    Args:
        text (str): The input text to process
        system_prompt (str): The system prompt to use
        model (str): The model to use
        max_tokens (int): Maximum tokens in the response
        temperature (float): Temperature for response generation
        
    Returns:
        str: The model's response text
    """
    url = "https://api.openai.com/v1/chat/completions"
    headers = {
        "Authorization": f"Bearer {OPENAI_API_KEY}",
        "Content-Type": "application/json"
    }
    payload = {
        "model": model,
        "messages": [
            {"role": "system", "content": system_prompt},
            {"role": "user", "content": text}
        ],
        "max_tokens": max_tokens,
        "temperature": temperature
    }
    res = requests.post(url, headers=headers, json=payload)
    return res.json()["choices"][0]["message"]["content"]