#!/bin/bash

# Debug script to run OpenHermes dataset generation with only 1 item
# Make sure the server is running first!

echo "🐛 Starting OpenHermes dataset generation (DEBUG MODE - 1 item only)..."

python script/dataset/create/create_openhermes_direct_fast.py \
    --model_path "Qwen/Qwen3-30B-A3B-Instruct-2507" \
    --api_url "http://localhost:30000/v1" \
    --dataset_path "teknium/OpenHermes-2.5" \
    --output_dir "local/teacher_datasets/openhermes_qwen_output" \
    --max_concurrent_requests 2 \
    --max_new_tokens 2048 \
    --temperature 0.7 \
    --top_p 0.8 \
    --top_k 20 \
    --min_p 0.0 \
    --request_timeout 6000 \
    --num_items 70002 \
    --is_print \
    --resume

echo "✅ Debug generation completed!"
