#!/bin/bash

# Multi-GPU evaluation script for MMLUFilteredChatDataset
# Usage: ./run_mmlu_filtered_eval.sh [config_file] [data_path] [split] [num_samples] [sample_interval]

# Default parameters
CONFIG_FILE=${1:-"./mmlu_filtered_eval_config.json"}
DATA_PATH=${2:-"./teacher_datasets/slm_only"}
SPLIT=${3:-"test"}
NUM_SAMPLES=${4:-""}
SAMPLE_INTERVAL=${5:-"1"}

echo "=== MMLUFilteredChatDataset Multi-GPU Evaluation ==="
echo "Config file: $CONFIG_FILE"
echo "Data path: $DATA_PATH"
echo "Split: $SPLIT"
echo "Number of samples: ${NUM_SAMPLES:-"All"}"
echo "Sample interval: $SAMPLE_INTERVAL"
echo "=================================================="

# Build command
CMD="python ./test_mmlu_filtered_dataset.py"
CMD="$CMD --config $CONFIG_FILE"
CMD="$CMD --data_path $DATA_PATH"
CMD="$CMD --split $SPLIT"
CMD="$CMD --sample_interval $SAMPLE_INTERVAL"

# Add num_samples if specified
if [ ! -z "$NUM_SAMPLES" ]; then
    CMD="$CMD --num_samples $NUM_SAMPLES"
fi

echo "Running command: $CMD"
echo ""

# Execute
$CMD
