from enum import Enum

# Environment names
POMNIST = "POMNIST"
TRAFFIC_JUNCTION = "TrafficJunction"

# Message modes
PSEUDOGRADIENT = "PseudoGradient"
DISCRETE = "Discrete"
CONTINUOUS = "Continuous"
DRU = "DRU"
ZEROS = "Zeros"

# Message decode modes
AGGREGATE_MEAN = "AggregateMean"
AGGREGATE_SUM = "AggregateSum"
CONCAT = "Concat"

# Config Keys
ENV_NAME = "env_name"
EXP_TAG = "experiment_tag"
COMMON_CONFIG = "common_config"
ENV_CONFIG = "env_configs"
SPLITS = "splits"
X_SPLITS = "x_splits"
Y_SPLITS = "y_splits"
MSG_SIZES = "msg_sizes"
CHANNEL_SIZES = "channel_sizes"
NUM_RUNS = "num_runs"

# Stat labels
AVG_RETURNS = "avg_returns"
AVG_CHANNEL_UTIL = "avg_channel_util"
AVG_NUM_DROPS = "avg_num_drops"
AVG_MSG_SIZE = 'avg_msg_size'
TITLE = "title"
XLABEL = "xlabel"
YLABEL = "ylabel"
PLOT_LABEL_DICT = {
    AVG_RETURNS: {TITLE: "Mean return",
                  XLABEL: "Number of iterations",
                  YLABEL: "Mean agent return"},
    AVG_CHANNEL_UTIL: {TITLE: "Mean throughput",
                       XLABEL: "Number of iterations",
                       YLABEL: "Mean throughput"},
    AVG_NUM_DROPS: {TITLE: "Mean number of drops",
                    XLABEL: "Number of iterations",
                    YLABEL: "Mean number of drops"},
    AVG_MSG_SIZE: {TITLE: "Mean chosen message size",
                    XLABEL: "Number of iterations",
                    YLABEL: "Mean chosen message size"}
}


class StrEnum(str, Enum):
    """
    Enum whose values can be used interchangeably with strings.
    """
    pass


class ChannelType(StrEnum):
    Perfect = 'Perfect'
    Blocking = 'Blocking'
    Stochastic = 'Stochastic'
    StochasticSpacing = 'StochasticSpacing'
    Permutation = 'Permutation'
    PermutationPrioritized = 'PermutationPrioritized'
    SelectiveChannel = 'SelectiveChannel'

