import gym


class MaxStepsWrapper(gym.Wrapper):
    def __init__(self, env, max_steps):
        super().__init__(env)
        self.env = env
        self.max_steps = max_steps
        self.steps = 0

    def reset(self):
        self.steps = 0
        return self.env.reset()

    def step(self, action):
        self.steps += 1
        obs, reward, done, info = self.env.step(action)
        return obs, reward, done or self.steps >= self.max_steps, info
