# Supplementary Material

Dear reviewers,  

We would like to thank you for your careful review. This is the supplementary material for our ICLR 2026 submission. We hope this material helps you understand the exact implementation of our experiments.

## Installation

Please run the following commands to install the dependencies.

```
python3 -m venv venv
source venv/bin/activate
pip install -r requirements.txt
```

## Execution

Please run the following command to train and evaluate an agent in a 9x9 Go environment.

```
python3 main.py env_id=go_9x9
```

Choose an environment from the following list: `connect_four`, `animal_shogi`, `gardner_chess`, `go_9x9`, `hex`, and `Othello`. If you do not specify, `connect_four` will be chosen by default.

Please make sure that you have activated the virtual environment before the execution. The execution may require a GPU with CUDA 12.

## Contents
* `main.py` is the main file that trains and evaluates the agent.
* `resnet.py` provides the residual network architecture with policy and action-value heads.
* `util.py` provides a useful function for handling `jax.random.key`.
* `README.md` is this file.
* `requirements.txt` provides the information of dependencies. 
