package com.samples.a2a;

import io.a2a.server.PublicAgentCard;
import io.a2a.spec.AgentCapabilities;
import io.a2a.spec.AgentCard;
import io.a2a.spec.AgentSkill;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Produces;
import jakarta.inject.Inject;
import java.util.Collections;
import java.util.List;
import org.eclipse.microprofile.config.inject.ConfigProperty;

/**
 * Producer for advisor search agent card configuration.
 * This class is final and not designed for extension.
 */
@ApplicationScoped
public final class AdvisorSearchAgentCardProducer {

  /** The HTTP port for the agent service. */
  @Inject
  @ConfigProperty(name = "quarkus.http.port")
  private int httpPort;

  /**
   * Gets the HTTP port.
   *
   * @return the HTTP port
   */
  public int getHttpPort() {
    return httpPort;
  }

  /**
   * Produces the agent card for the advisor search agent.
   *
   * @return the configured agent card
   */
  @Produces
  @PublicAgentCard
  public AgentCard agentCard() {
    return new AgentCard.Builder()
        .name("Advisor Search Agent")
        .description("An agent that can search and recommend financial advisors based on user preferences and requirements.")
        .url("http://localhost:" + getHttpPort())
        .version("1.0.0")
        .documentationUrl("http://example.com/docs")
        .capabilities(
            new AgentCapabilities.Builder()
                .streaming(true)
                .pushNotifications(false)
                .stateTransitionHistory(false)
                .build())
        .defaultInputModes(Collections.singletonList("text"))
        .defaultOutputModes(Collections.singletonList("text"))
        .skills(
            Collections.singletonList(
                new AgentSkill.Builder()
                    .id("advisor_search")
                    .name("Search financial advisors")
                    .description("Searches and recommends financial advisors based on criteria like experience, specialties, ratings")
                    .tags(List.of("advisor", "finance", "search", "investment"))
                    .examples(
                        List.of(
                            "Find experienced advisors with retirement planning expertise",
                            "Recommend highly-rated advisors for tax optimization"))
                    .build()))
        .protocolVersion("0.3.0")
        .build();
  }
}