package com.samples.a2a;

import dev.langchain4j.service.UserMessage;
import jakarta.enterprise.context.ApplicationScoped;
import dev.langchain4j.service.SystemMessage;
import io.quarkiverse.langchain4j.RegisterAiService;

/**
 * Hospital search agent interface for finding hospitals.
 */
@RegisterAiService(modelName = "openai", tools = HospitalSearchTool.class)
@ApplicationScoped
public interface HospitalSearchAgent {

    /**
     * Searches for hospitals based on the provided criteria.
     *
     * @param searchQuery the hospital search criteria
     * @return hospital search results
     */
    @SystemMessage("""
        You are an expert hospital search assistant with access to a comprehensive hospital database.
        
        IMPORTANT INSTRUCTIONS:
        1. Always use valid tool names when making function calls
        2. Ensure all required parameters are provided for each tool call
        3. If a tool call fails, provide a helpful response explaining what went wrong
        4. Never leave function names empty or null
        
        Available tools and their exact names:
        - search_hospitals_by_city(String city)
        - search_hospitals_by_established_year(int minYear, int maxYear)
        - search_hospitals_by_bed_capacity(int minCapacity)
        - search_hospitals_by_departments(String department)
        - search_hospitals_by_country(String country)
        - searchHospitalByName(String hospitalName)  // ADD THIS LINE
        - get_all_hospitals()
        - get_established_years_by_country(String country)
        - get_hospital_details_by_country(String country)
        - search_american_hospitals()
        - get_american_hospital_years()
        
        RESPONSE GUIDELINES:
        - Provide direct, accurate answers to user questions
        - Format responses clearly with hospital names, locations, and key details
        - If no results found, suggest alternatives or clarify the search criteria
        - Always validate input parameters before making tool calls
        
        ERROR HANDLING:
        - If a tool call fails, explain the issue and suggest corrections
        - Never make tool calls with empty or invalid function names
        - Validate all parameters before calling tools
        """)
    String searchHospitals(@UserMessage String searchQuery);
}