package com.samples.a2a;

import io.a2a.server.PublicAgentCard;
import io.a2a.spec.AgentCapabilities;
import io.a2a.spec.AgentCard;
import io.a2a.spec.AgentSkill;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Produces;
import jakarta.inject.Inject;
import java.util.Collections;
import java.util.List;
import org.eclipse.microprofile.config.inject.ConfigProperty;

/**
 * Producer for hospital search agent card configuration.
 * This class is final and not designed for extension.
 */
@ApplicationScoped
public final class HospitalSearchAgentCardProducer {  // Changed class name

  /** The HTTP port for the agent service. */
  @Inject
  @ConfigProperty(name = "quarkus.http.port")
  private int httpPort;

  /**
   * Gets the HTTP port.
   *
   * @return the HTTP port
   */
  public int getHttpPort() {
    return httpPort;
  }

  /**
   * Produces the agent card for the hospital search agent.
   *
   * @return the configured agent card
   */
  @Produces
  @PublicAgentCard
  public AgentCard agentCard() {
    return new AgentCard.Builder()
        .name("Hospital Search Agent")  // Changed name
        .description("An agent that can search and recommend hospitals based on medical facility requirements.")  // Changed description
        .url("http://localhost:" + getHttpPort())
        .version("1.0.0")
        .documentationUrl("http://example.com/docs")
        .capabilities(
            new AgentCapabilities.Builder()
                .streaming(true)
                .pushNotifications(false)
                .stateTransitionHistory(false)
                .build())
        .defaultInputModes(Collections.singletonList("text"))
        .defaultOutputModes(Collections.singletonList("text"))
        .skills(
            Collections.singletonList(
                new AgentSkill.Builder()
                    .id("hospital_search")  // Changed skill ID
                    .name("Search hospitals")  // Changed skill name
                    .description("Searches and recommends hospitals based on criteria like city, established year, bed capacity, medical departments")  // Changed description
                    .tags(List.of("hospital", "medical", "search", "healthcare"))  // Changed tags
                    .examples(
                        List.of(  // Changed examples
                            "Find hospitals in Paris with over 1000 beds",
                            "Search for hospitals with Cardiology department established after 1950",
                            "Recommend hospitals in Tokyo with emergency services"))
                    .build()))
        .protocolVersion("0.3.0")
        .build();
  }
}