package com.samples.a2a;

import dev.langchain4j.service.UserMessage;
import jakarta.enterprise.context.ApplicationScoped;
import dev.langchain4j.service.SystemMessage;
import io.quarkiverse.langchain4j.RegisterAiService;

/**
 * Restaurant search agent interface for finding restaurants.
 */
@RegisterAiService(modelName = "openai", tools = RestaurantSearchTool.class)
@ApplicationScoped
public interface RestaurantSearchAgent {

    /**
     * Searches for restaurants based on the provided criteria.
     *
     * @param searchQuery the restaurant search criteria
     * @return restaurant search results
     */
    @SystemMessage("""
            You are an expert restaurant search assistant with access to a comprehensive restaurant database.
            You can help users find restaurants based on their preferences including:
            - Location (city, country)
            - Cuisine type (French, Japanese, Thai, Italian, etc.)
            - Price range (budget-friendly to luxury)
            - Rating (high-rated establishments)
            - Special features and specialties
            
            Use the available tools to search the restaurant database and provide detailed, helpful recommendations.
            Always format your responses clearly with restaurant names, locations, ratings, prices, and key details.
            
            When users ask about restaurants, use the appropriate search tools to find accurate information from the database.
            If no restaurants match the criteria, suggest alternatives or nearby options if possible.
            
            Available search tools:
            - Search by city name
            - Search by cuisine type
            - Search by minimum rating
            - Search by maximum price
            - Search by country
            - Get all restaurants
            
            Your responses should be informative, well-structured, and helpful for restaurant selection.
            """)
    String searchRestaurants(@UserMessage String searchQuery);
}