package com.samples.a2a;

import io.a2a.server.PublicAgentCard;
import io.a2a.spec.AgentCapabilities;
import io.a2a.spec.AgentCard;
import io.a2a.spec.AgentSkill;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Produces;
import jakarta.inject.Inject;
import java.util.Collections;
import java.util.List;
import org.eclipse.microprofile.config.inject.ConfigProperty;

/**
 * Producer for restaurant search agent card configuration.
 * This class is final and not designed for extension.
 */
@ApplicationScoped
public final class RestaurantSearchAgentCardProducer {

  /** The HTTP port for the agent service. */
  @Inject
  @ConfigProperty(name = "quarkus.http.port")
  private int httpPort;

  /**
   * Gets the HTTP port.
   *
   * @return the HTTP port
   */
  public int getHttpPort() {
    return httpPort;
  }

  /**
   * Produces the agent card for the restaurant search agent.
   *
   * @return the configured agent card
   */
  @Produces
  @PublicAgentCard
  public AgentCard agentCard() {
    return new AgentCard.Builder()
        .name("Restaurant Search Agent")
        .description("An agent that can search and recommend restaurants based on user preferences.")
        .url("http://localhost:" + getHttpPort())
        .version("1.0.0")
        .documentationUrl("http://example.com/docs")
        .capabilities(
            new AgentCapabilities.Builder()
                .streaming(true)
                .pushNotifications(false)
                .stateTransitionHistory(false)
                .build())
        .defaultInputModes(Collections.singletonList("text"))
        .defaultOutputModes(Collections.singletonList("text"))
        .skills(
            Collections.singletonList(
                new AgentSkill.Builder()
                    .id("restaurant_search")
                    .name("Search restaurants")
                    .description("Searches and recommends restaurants based on criteria like location, cuisine, price range")
                    .tags(List.of("restaurant", "food", "search"))
                    .examples(
                        List.of(
                            "Find Italian restaurants near downtown",
                            "Recommend budget-friendly Chinese restaurants with good ratings"))
                    .build()))
        .protocolVersion("0.3.0")
        .build();
  }
}