Policy Optimization under Imperfect Human Interactions with Agent-Gated Shared Autonomy


## Installation

1. Install and use the Ananconda environment
```
$ conda env create -f environment.yml
$ conda activate agsa
```
You'll need to [get your own MuJoCo key](https://www.roboti.us/license.html) if you want to use MuJoCo.

2. Add this repo directory to your `PYTHONPATH` environment variable.
```
$ export PYTHONPATH="$PYTHONPATH:$(pwd)"
```

3. Add RLIF to your `PYTHONPATH` to load expert policies.
```
$ git clone https://github.com/pd-perry/RLIF
$ cd RLIF
$ export PYTHONPATH="$PYTHONPATH:$(pwd)"
```

## Datasets and Experts
The datasets used in this experiment are downloaded [here](https://drive.google.com/file/d/1-jybdj0vKF9Zp1OAdfiQBcMk-_F7aPBf/view?usp=sharing) and the expert agents are downloaded [here](https://drive.google.com/file/d/1UhT_Y-Nmxk67nGiwHTrD7lnQyaU0llB4/view?usp=sharing). 

## Run Experiments
```
# Run this with a subdirectory called AGSA
bash AGSA/scripts/run_hopper_sve.sh
bash AGSA/scripts/run_walker2d_sve.sh
bash AGSA/scripts/run_halfcheetah_sve.sh
```

## Credits
The implementation of AGSA builds on the implementation of [RLIF](https://github.com/pd-perry/RLIF) by Jianlan Luo and Perry Dong. 