#!/bin/bash

#export CUDA_VISIBLE_DEVICES=0
export LD_LIBRARY_PATH=$LD_LIBRARY_PATH:/home/ubuntu/.mujoco/mujoco210/bin
export LD_LIBRARY_PATH=$LD_LIBRARY_PATH:/usr/lib/nvidia
export XLA_PYTHON_CLIENT_PREALLOCATE=false
export D4RL_SUPPRESS_IMPORT_ERROR=1


export N_GPUS=$(nvidia-smi -L | wc -l)
export N_JOBS=18


parallel -j $N_JOBS --linebuffer --delay 1 \
    'CUDA_VISIBLE_DEVICES=$(({%} % 4)) 'python -m AGSA.examples.train_rlphi_main \
            --seed={1} \
            --project_name='{2}' \
            --env_name='{3}' \
            --sparse_env={4} \
            --dataset_dir={5} \
            --offline_ratio={6} \
            --eval_episodes=50 \
            --log_interval=1000 \
            --eval_interval=2000 \
            --max_traj_length={7} \
            --utd_ratio={8} \
            --ground_truth_agent_dir={9} \
            --intervene_threshold={10} \
            --intervention_strategy={11} \
            --expert_dir={12} \
            --save_model=False \
            --intervene_type='neural_rl' \
            --adj_acc_rew_ratio={13} \
            --threshold_n_steps={14} \
            --use_pbrl=True \
            --pbrl_rew_ratio={15} \
            --combine_un=True \
        ::: 24 42 43 \
        ::: 'halfcheetah-sve-tune' \
        ::: "halfcheetah-expert-v2" \
        ::: 'HalfCheetah-v2' \
        ::: '' \
        ::: 0.0 \
        ::: 1000 \
        ::: 15 \
        ::: './AGSA/experts/rlpd_experts/s24_halfcheetah-expert-v2env/high/model.pkl' \
        ::: 0.99 \
        ::: 'q' \
        ::: './AGSA/experts/rlpd_experts/s24_halfcheetah-expert-v2env/high/model.pkl' './AGSA/experts/rlpd_experts/s24_halfcheetah-expert-v2env/medium/model.pkl' './AGSA/experts/rlpd_experts/s24_halfcheetah-expert-v2env/low/model.pkl' \
        ::: 0.6\
        ::: 3\
        ::: 0.06\