#!/bin/bash

#export CUDA_VISIBLE_DEVICES=0
export LD_LIBRARY_PATH=$LD_LIBRARY_PATH:/home/ubuntu/.mujoco/mujoco210/bin
export LD_LIBRARY_PATH=$LD_LIBRARY_PATH:/usr/lib/nvidia
export XLA_PYTHON_CLIENT_PREALLOCATE=false
export D4RL_SUPPRESS_IMPORT_ERROR=1


export N_GPUS=$(nvidia-smi -L | wc -l)
export N_JOBS=36


parallel -j $N_JOBS --linebuffer --delay 1 \
    'CUDA_VISIBLE_DEVICES=$(({%} % 4)) 'python -m AGSA.examples.train_rlphi_main \
            --seed={1} \
            --project_name='{2}' \
            --env_name='{3}' \
            --sparse_env={4} \
            --dataset_dir={5} \
            --offline_ratio={6} \
            --eval_episodes=50 \
            --log_interval=1000 \
            --eval_interval=2000 \
            --max_traj_length={7} \
            --utd_ratio={8} \
            --ground_truth_agent_dir={9} \
            --intervene_threshold={10} \
            --intervention_strategy={11} \
            --use_p_intervene=True \
            --expert_dir={12} \
            --p_intervene_threshold={13} \
            --save_model=False \
            --intervene_type='neural_rl' \
            --adj_acc_rew_ratio={14} \
            --threshold_n_steps={15} \
            --use_pbrl=True \
            --pbrl_rew_ratio={16} \
            --combine_un=True \
            --p_intervene_threshold={17} \
        ::: 24 42 43 \
        ::: 'hopper-sve-tune' \
        ::: "hopper-expert-v2" \
        ::: 'Hopper-v2' \
        ::: './AGSA/iclr_datasets/hopper-expert-v2_50trajs' \
        ::: 0.0 \
        ::: 1000 \
        ::: 15 \
        ::: './AGSA/experts/rlpd_experts/s24_hopper-expert-v2env/model.pkl' \
        ::: 0.975 \
        ::: 'q' \
        ::: './AGSA/experts/rlpd_experts/s24_hopper-expert-v2env/model.pkl' './AGSA/experts/bc_experts/b750e30dc83a4158a7ded9ccc8ef3298/model.pkl' './AGSA/experts/bc_experts/6d31b3a8d5d049dfa08676fb6fc8eb20/model.pkl' \
        ::: 0.3\
        ::: 0.6\
        ::: 2 \
        ::: 0.03 \
        ::: 0.03 \