#!/bin/bash

#export CUDA_VISIBLE_DEVICES=0
export LD_LIBRARY_PATH=$LD_LIBRARY_PATH:/home/ubuntu/.mujoco/mujoco210/bin
export LD_LIBRARY_PATH=$LD_LIBRARY_PATH:/usr/lib/nvidia
export XLA_PYTHON_CLIENT_PREALLOCATE=false
export D4RL_SUPPRESS_IMPORT_ERROR=1


export N_GPUS=$(nvidia-smi -L | wc -l)
export N_JOBS=1


parallel -j $N_JOBS --linebuffer --delay 1 \
    'CUDA_VISIBLE_DEVICES=$(({%} % 4)) 'python -m AGSA.examples.train_rlphi_main \
            --seed={1} \
            --project_name='{2}' \
            --env_name='{3}' \
            --sparse_env={4} \
            --dataset_dir={5} \
            --offline_ratio={6} \
            --eval_episodes=50 \
            --log_interval=1000 \
            --eval_interval=2000 \
            --max_traj_length={7} \
            --utd_ratio={8} \
            --ground_truth_agent_dir={9} \
            --intervene_threshold={10} \
            --intervention_strategy={11} \
            --expert_dir={12} \
            --save_model=False \
            --intervene_type='neural_rl' \
            --pretrain_steps={13} \
            --adj_acc_rew_ratio={14} \
            --threshold_n_steps={15} \
            --use_pbrl=True \
            --pbrl_normalizing_ratio={16} \
            --pbrl_rew_ratio={17} \
	        --combine_un=True \
        ::: 24 42 43 \
        ::: 'walker2d-sve' \
        ::: "walker2d-expert-v2" \
        ::: 'Walker2d-v2' \
        ::: './AGSA/iclr_datasets/walker2d-expert-v2_10trajs' \
        ::: 0.0 \
        ::: 1000 \
        ::: 1 \
        ::: './AGSA/experts/bc_experts/461a33ca2a8c48f497acfce6bf4eb0e7/model.pkl' \
        ::: 0.99 \
        ::: 'q' \
        ::: './AGSA/experts/bc_experts/461a33ca2a8c48f497acfce6bf4eb0e7/model.pkl' './AGSA/experts/bc_experts/59456c494a8a4ff988178c1524e36298/model.pkl' './AGSA/experts/bc_experts/9cd6157b007942ac95d8d8d870b38941/model.pkl' \
        ::: 0 \
        ::: 0.6 \
        ::: 2 \
        ::: 0.0001 \
        ::: 0.03 \
