GPU_ID=0
DIS_MIXUP=mixup # mixup, none

DISK_DATA=../datasets/celeba_hq
SAMPLE_DIR=../stargan-expr/celeba_hq_samples_${DIS_MIXUP}
CHECKPOINTS_DIR=../stargan-expr/celeba_hq_checkpoints_${DIS_MIXUP}
EVAL_DIR=../stargan-expr/celeba_hq_eval_${DIS_MIXUP}
WING_PATH=checkpoints/wing.ckpt
LM_PATH=checkpoints/celeba_lm_mean.npz

CUDA_VISIBLE_DEVICES=${GPU_ID} python3 main.py \
  --num_domains 2 \
  --mode train \
  --batch_size 4 \
  --w_hpf 1 \
  --lambda_reg 1 \
  --lambda_sty 2 \
  --lambda_ds 1 \
  --lambda_cyc 1 \
  --lambda_mixup 1 \
  --lambda_shr 0.1 \
  --dis_mixup ${DIS_MIXUP} \
  --total_iters 100000 \
  --sample_every 5000 \
  --eval_every 100000 \
  --save_every 5000 \
  --ds_iter 100000 \
  --train_img_dir ${DISK_DATA}/train \
  --val_img_dir ${DISK_DATA}/val \
  --sample_dir ${SAMPLE_DIR} \
  --checkpoint_dir ${CHECKPOINTS_DIR} \
  --eval_dir ${EVAL_DIR} \
  --val_batch_size 4 \
  --wing_path ${WING_PATH} \
  --lm_path ${LM_PATH}

  