# IPMF with ASBM

## Requirements ##
Create the Anaconda environment with the following command:
```
conda env create -f environment.yml
```

Then install the package `eot_benchmark` following the [repo](https://github.com/ngushchin/EntropicOTBenchmark).

> **NB!** Before running any scripts, change the directory of the desired experiment.

## Toy (Swiss-roll) ##
1. To pretrain ASBM for toy experiments before running IPMF procedure with $\epsilon=0.1$ and $T=4$ run the following script:
```
bash pretrain_toy.sh 'ind_id'
```
where the first parameter corresponds to different initializations. Following options include `ind_id`, `ind`, `ipf`.

2. To run IPMF procedure for toy experiment with $\epsilon=0.1$ and $T=4$ after one-sided pretraining run the following script:
```
bash train_toy.sh 'ind_id'
```
where the first parameter corresponds to differnet initializations. Following options include `ind_id`, `ind`, `ipf`.


## Entropy OT/SB benchmark ##
To reproduce results from the paper for Entropy OT/SB benchmark choose the values for dimension (`2`, `16`, `64`, `128`), epsilon (`0.1`, `1.0`, `10.0`) and initialization (`ind_id`, `ind`, `ipf`) respectively to script argument number. For example, to run pretraining with $dim=16$, $\epsilon=1$ and IPF initialization run following script:
```
bash pretrain_bench.sh 16 1.0 'ipf'
```
After pretraining all checkpoints will be available at: 

```
sb_bench_results/dim_<dim>_eps_<eps>/T_32_<plan>_<f or b>/<%d:%m:%y_%H:%M:%S>_exp/
```
 
Rename `<%d:%m:%y_%H:%M:%S>_exp` folder name to `main_result`.

For IPMF procedure in the same manner specify dimension, $\epsilon$,  and initialization and following previous example run:
```
bash train_bench.sh 16 1.0 'ipf'
```

## Colored MNIST ##
To reproduce results from the paper for the Colored MNIST experiment, first specify the epsilon and initialization plan, `inv_color`, `ind`, `ipf` are available. Secondly, for example, $\epsilon=10$ and inverted color run:
```
bash train_cmnist.sh 10.0 'inv_color'
```
## CelebA ##

### Download CelebA ###
Download CelebA dataset using the [link](https://drive.google.com/uc?export=download&id=0B7EVK8r0v71pZjFTYXZWM3FlRnM), unzip it and set the variable `path_to_celeba` in training scripts for Celeba accordingly. 

### ASBM-IPMF CelebA-64 Training Procedure ###
The ASBM-IPMF model is trained in two distinct stages: first, the initialization is learned, followed by the execution of the D-IPMF procedure.

#### Celeba-64, One-Sided Pretraining ####
To pretrain the ASBM for the *Ind* $p_0 \rightarrow p_0$ coupling for male-to-male translation before running the D-IPMF procedure, use the following script:
```bash
bash train_celeba_64_male2male_ema_T_4_eps_1_identity_permute.sh
```
For D-IPMF training, you will also need to pretrain a second model for female-to-female translation. This can be done by running the following script:
```bash
bash train_celeba_64_female2female_ema_T_4_eps_1_identity_permute.sh
```

Similarly, to train the model with the Mini-Batch Optimal Transport (MB) coupling, referred to as IMF, for male-to-female and female-to-male translation, run the following scripts:
```bash
bash train_celeba_64_male2female_ema_T_4_minibatch_ot_eps_1.sh
```
```bash
bash train_celeba_64_female2male_ema_T_4_minibatch_ot_eps_1.sh
```
In all the scripts, you must specify the name of the experiment by setting the `exp_name` variable. This variable will later be required for model initialization during the D-IPMF training. Additionally, the `data_root` variable needs to be updated with the correct path to the CelebA dataset.

#### Celeba-64, D-IPMF Training ####
To run the D-IPMF procedure for CelebA-64 after one-sided pretraining with *Ind* $p_0 \rightarrow p_0$ coupling, use the following script:
```bash
bash train_celeba_64_T_4_imf_ema_sampling_eps_1_identity_permute_init.sh
```
For the IMF initial coupling, execute the following script:
```bash
bash train_celeba_64_T_4_imf_ema_sampling_eps_1_minibatch_ot_init.sh
```
In these scripts, the `data_root` variable must be set to the path of the CelebA dataset. Additionally, you need to initialize the models from the pretraining stage by assigning the `exp_forward` and `exp_backward` variables with the value of the `exp_name` from the pretraining step, corresponding to the forward and reverse processes, respectively. For the `exp_forward_model` and `exp_backward_model` variables, specify the checkpoint names from which you want to initialize your models.