
## Reproducing experiments
### Setting up

We provide a list of python packages necessary to run the code in `requirements.txt` file.

In order to set up an environment you must have python 3.10, Cuda 12 and then run:

`pythom install -r requirements.txt`

### Swiss Roll experiment

Run `DSBM_SwissRoll.ipynb` notebook and set the starting process in cell 3 variable `starting_prior`.

### Schr&ouml;dinger Bridge Benchmark

Install Scr&ouml;dinger Bridge or Entropic Optimal Transort Benchmark following official instructions [github repo](https://github.com/ngushchin/EntropicOTBenchmark).

Run `DSBM_SB_Bench.ipynb` notebook and set the starting process in cell 3 variable `starting_prior`.

### Colored MNIST experiment

DSBM-IPF: `. dsbm_colored_mnist_eps_3_ipf.sh`

DSBM-IMF: `. dsbm_colored_mnist_eps_3_imf.sh`

DSBM-$p^{\text{Inv}7}$ : `. dsbm_colored_mnist_eps_3_inversed_7s_prior.sh`

### CelebA

#### Download CelebA ####
Download CelebA dataset using the [link](https://drive.google.com/uc?export=download&id=0B7EVK8r0v71pZjFTYXZWM3FlRnM), unzip it and set the variable `path_to_celeba` in training scripts for Celeba accordingly. 

#### DSBM-IPMF CelebA-64 ####
To train the DSBM model on the CelebA dataset using the IPMF procedure, two different initial joint distributions can be employed. For training with the Mini-Batch Optimal Transport (MB) coupling, denoted as IMF, execute the following script:
```bash
bash dsbm_celeba_eps_1_imf.sh
```
and with the *Ind* $p_0 \rightarrow p_0$ coupling you need to run the following script:
```bash
bash dsbm_celeba_eps_1_ind_p0.sh
```
In both scripts, the `path_to_celeba` variable must be updated to specify the path to the CelebA dataset, and the `path_to_save_info` variable should be set to the directory where the experiment results will be stored. Additionally, other hyperparameters can be modified as needed.