"""
 Copyright (c) 2022, salesforce.com, inc.
 All rights reserved.
 SPDX-License-Identifier: BSD-3-Clause
 For full license text, see the LICENSE file in the repo root or https://opensource.org/licenses/BSD-3-Clause
"""

from lavis.datasets.builders.base_dataset_builder import BaseDatasetBuilder
from lavis.common.registry import registry
from lavis.datasets.datasets.instruction_datasets import RefineDataset

@registry.register_builder("Refine_All_tune")
class RefineBuilder_All_tune(BaseDatasetBuilder):
    train_dataset_cls = RefineDataset

    DATASET_CONFIG_DICT = {
        "default": "configs/datasets/instruction/defaults_refine_all_tune.yaml",
    }

@registry.register_builder("Refine_All_eval")
class RefineBuilder_All_eval(BaseDatasetBuilder):
    eval_dataset_cls = RefineDataset

    DATASET_CONFIG_DICT = {
        "default": "configs/datasets/instruction/defaults_refine_all_eval.yaml",
    }
