# Instructions for reproducing key experiments of the paper is provided here.
# To train on other tasks, change the corresponding config files accordingly.

# Move to the directory of iEF_codebase_submission

> cd <PATH_TO_FOLDER>/iEF_codebase_submission

# Setup environment
## Please run the following line to install all needed environments

> bash ./bash_files/requirements_installation.sh

# Run Experiments:
## Make sure you are registered with wandb.ai to see training curves
## Make sure you have activated the "ml" virtual environment, and have cd to .../iEF_codebase_submission

# 1. Run evaluation on SST2 + Prompt Tuning + T5
## An example checkpoint for the 11th epoch of SSG2 + Prompt Tuning + T5 trained with Adafactor is provided in ./sample_ckpts/sst2_t5_prompt_tuning_epoch11
## run the following line to do an evaluation on several damping factors for this checkpoint
## results are outputed in ./sample_ckpts/sst2_t5_prompt_tuning_epoch9/precond_eval, ending with -dmp-{damping factor}.npy

> python3 ./run.py --seed 1337 -m evaluate-preconditioner --expdir ./expdir --config ./configs/t5-prompt-tuning-preconditioner-evaluation.yaml --wandb_project precond_eval_glue --wandb_run_name sst2_t5_pt

# 2. Run evaluation on CIFAR100 + LoRA + ViT
## An example checkpoint for the 9th epoch of SSG2 + Prompt Tuning + T5 trained with Adafactor is provided in ./example_ckpts/cifar_vit_lora_e2
## run the following line to do an evaluation on several damping factors for this checkpoint
## results are outputed in ./example_ckpts/cifar_vit_lora_e2/precond_eval, ending with -dmp-{damping factor}.npy

> python3 ./run.py --seed 1337 -m evaluate-preconditioner-vis --expdir ./expdir --config ./configs/vit-lora-preconditioner-evaluation.yaml --wandb_project precond_eval_cifar --wandb_run_name cifar100_vit_lora

# 3. Run Prompt Tuning from scratch on SST2 + T5:
## run the following line to do full iEF training

> python3 ./run.py --seed 1337 -m train  --expdir ./expdir --config ./configs/t5-prompt-tuning-iEF.yaml --wandb_project train_glue --wandb_run_name sst2_t5_pt_iEF

# 4. Run LoRA from scratch on CIFAR100 + ViT:
## run the following line to do full iEF training

> python3 ./run.py --seed 1337 -m train-vis  --expdir ./expdir --config ./configs/vit-lora-iEF.yaml  --wandb_project train_cifar100 --wandb_run_name cifar100_vit_lora_iEF

