from .search_engine import SearchEngine
from .code_engine import CodeEngine
from enum import Enum
import ray


class ToolType(Enum):
    Search = "search"
    Code = "code"


TOOL_TYPE_TO_TOOL_ENGINE = {
    ToolType.Search: SearchEngine,
    ToolType.Code: CodeEngine,
}


def build_tool_engines(config):
    tool_app_addresses = dict()
    tool_engines = []

    for tool_type in TOOL_TYPE_TO_TOOL_ENGINE:
        cur_tool_config = getattr(config, tool_type.value, None)
        if cur_tool_config is not None and cur_tool_config.enable:
            if tool_type not in tool_app_addresses:
                tool_app_addresses[tool_type] = []
            for _ in range(cur_tool_config.num_instance):
                engine = (
                    TOOL_TYPE_TO_TOOL_ENGINE[tool_type]
                    .options(
                        num_cpus=cur_tool_config.num_cpus,
                        num_gpus=cur_tool_config.num_gpus,
                    )
                    .remote(cur_tool_config)
                )
                ray.get(engine.prepare_env.remote())
                engine_address = ray.get(engine.get_server_address.remote())
                tool_app_addresses[tool_type].append(engine_address)
                tool_engines.append(engine)

    return tool_app_addresses, tool_engines
