# OPTQ-RD
Repository for the paper _Rate/Distortion Constrained Model Quantization for Efficient Storage and Inference_, 
available under _[Link will be added upon publication]_.

## Installation
Before starting, make sure you have a C++17-compatible compiler installed.
Afterwards, install the project via executing `make install` in the root directory.

## Usage
To run experiments, first create the configurations for the experiments, running the following:

```python3 scripts/create_configurations.py```

You can overwrite the default arguments from the configurations for your needs. Information on the possible
parameters can be found via running

```python3 scripts/compress_network.py --help```

An example would be

```python3 scripts/create_configurations.py --results-folder out --nbatches 10 --acc-batches 5 --device cuda```

to have a configuration that is able to be run locally.

Afterwards, you can run an experiment with the following

```python3 scripts/compress_network.py yaml configurations/resnet18_baseline```

which will run all experiments in the folder. You can run a single experiment, for example the one for a 3 bit grid via

```python3 scripts/compress_network.py yaml configurations/resnet18_baseline/resnet18_baseline_3.yaml```

To test your installation, you can also run the tests via 
```pytest tests```. 
Make sure you have pytest installed (either via installing the dev dependencies below or by running ```pip install pytest```).


## Developer information
Follow the installation instructions from above. Afterwards, run

```pip install ".[dev]"```

in the project root.

### Git hooks
Before commiting, install the githooks via 

```python3 -m python_githooks```

## Authors
- Anonymous
