from nn_compression._core import DeepCabacRdQuantiser
import numpy as np


def test_smoke_layer_quant_single_value():
    q = DeepCabacRdQuantiser(1.0, 1.0, -5, 5)
    q.quantize(3, 3)


def test_smoke_layer_quant_multiple_values():
    q = DeepCabacRdQuantiser(1.0, 1.0, -5, 5)
    q.quantize(np.array([1, 2, 3]), 3)


def test_smoke_layer_quant_multiple_dimensions():
    q = DeepCabacRdQuantiser(1.0, 1.0, -5, 5)
    q.quantize(np.array([[1, 2, 3], [4, 5, 6]]), 3)


def test_smoke_layer_quant_multiple_posterior_values():
    q = DeepCabacRdQuantiser(1.0, 1.0, -5, 5)
    q.quantize(np.array([1, 2, 3]), np.array([1, 2, 3]))


def test_smoke_layer_quant_multiple_posterior_values_multidimension():
    q = DeepCabacRdQuantiser(1.0, 1.0, -5, 5)
    q.quantize(np.array([[1, 2, 3], [4, 5, 6]]), np.array([[1, 2, 3], [4, 5, 6]]))
