# ADDI

## Introduction

ADDI is an E2E autonomous driving method.


## Env requirements
torch >=1.13 # cuda>=11.6
torchvision
mmcv-full>=1.5.0
mmdet>=2.20.0
mmsegmentation>=0.20.0
mmdetection3d>=1.0.0 
av2
nuscenes-devkit
yapf==0.40.1
urllib3==1.26.16
pyquaternion==0.9.9
nuscenes-devkit==1.1.10
yapf==0.33.0
tensorboard==2.14.0
motmetrics==1.1.3
pandas>=1.1.5
flash-attn==2.3.2
opencv-python>=4.8.1.78
prettytable>=3.7.0
scikit-learn>=1.3.0
einops
casadi
torchmetrics
motmetrics==1.1.3 # Fixed
trimesh
pytest
pytest-cov
pytest-runner
yapf==0.40.1
flake8
trimesh==2.35.39
similaritymeasures
laspy==2.5.0
lazrs==0.5.3
py-trees==0.8.3
simple_watchdog_timer
transforms3d
tabulate
ephem
dictor
cython
numba==0.48.0 # In order to speed up
addict
packaging
Pillow
matplotlib
## Dataset 
nuScenes: Download nuScenes dataset to `./data/nuscenes`.

Argoverse2: Download Argoverse2 dataset to `./data/av2`.

## Dataset generate.
```bash
sh scripts/create_data.sh
```

```bash
sh scripts/kmeans.sh
```

## Run
```bash
cd projects/mmdet3d_plugin/ops
python3 setup.py develop
cd ../../../
```

```
sh scripts/train.sh
```

```
sh scripts/train_carla.sh

```


