#!/bin/bash
cd ../

setting='black'
runs=1
block_size=1000000
device=0

for dataset in ogbn-arxiv
do
    for ptb_rate in 0.10
    do
        python main.py --dataset $dataset --ptb_rate $ptb_rate --attack random --runs $runs --device $device
        python main.py --dataset $dataset --ptb_rate $ptb_rate --attack random --runs $runs --threshold 1.0 --device $device
        python main.py --dataset $dataset --ptb_rate $ptb_rate --attack dice --runs $runs --device $device
        python main.py --dataset $dataset --ptb_rate $ptb_rate --attack dice --runs $runs --threshold 1.0 --device $device

        for reg in 0.0 1.0 5.0
        do
        python main.py --dataset $dataset --ptb_rate $ptb_rate --block_size $block_size --setting $setting --attack gcos --loss peega --approx --reg $reg --runs $runs --device $device
        done

        for reg in 0.0 1.0 5.0
        do 
        python main.py --dataset $dataset --ptb_rate $ptb_rate --block_size $block_size --setting $setting --attack gcos --loss she --approx --reg $reg --runs $runs --device $device
        done
    done 
done