#!/bin/bash
cd ../

setting='black'
runs=5
for dataset in cora_ml citeseer pubmed
do
    if [ "$dataset" == "cora_ml" ] || [ "$dataset" == "citeseer" ]; then
        block_size=250000
    else
        block_size=500000
    fi

    for ptb_rate in 0.20
    do
        python main.py --dataset $dataset --ptb_rate $ptb_rate --attack random --runs $runs
        python main.py --dataset $dataset --ptb_rate $ptb_rate --attack random --runs $runs --threshold 1.0
        python main.py --dataset $dataset --ptb_rate $ptb_rate --attack dice --runs $runs
        python main.py --dataset $dataset --ptb_rate $ptb_rate --attack dice --runs $runs --threshold 1.0

        ####### PGD #######   
        if [ "$dataset" != "pubmed" ]; then       
        python main.py --dataset $dataset --ptb_rate $ptb_rate --block_size $block_size --setting $setting  --attack spec --runs $runs
        python main.py --dataset $dataset --ptb_rate $ptb_rate --block_size $block_size --setting $setting  --attack spec --approx --runs $runs
        python main.py --dataset $dataset --ptb_rate $ptb_rate --block_size $block_size --setting $setting  --attack gf --runs $runs
        fi

        ####### GRBCD #######
        python main.py --dataset $dataset --ptb_rate $ptb_rate --block_size $block_size --setting $setting  --attack gcos --loss self_atk --runs $runs

        for reg in 0.0 1.0 5.0
        do
        python main.py --dataset $dataset --ptb_rate $ptb_rate --block_size $block_size --setting $setting  --attack gcos --loss peega --reg $reg --runs $runs
        done
        for reg in 0.0 1.0 5.0
        do 
        python main.py --dataset $dataset --ptb_rate $ptb_rate --block_size $block_size --setting $setting  --attack gcos --loss she --reg $reg --runs $runs
        done
        for reg in 0.0 1.0 5.0
        do 
        python main.py --dataset $dataset --ptb_rate $ptb_rate --block_size $block_size --setting $setting  --attack gcos --loss she --reg $reg --runs $runs --approx
        done
    done 
done