import numpy as np
import pandas as pd
import torch

data = pd.read_csv("gt_2011.csv")

data = np.array(data)
print(data)
print(data.shape)

X = data[: , 0:9]
y = data[: , 9:10]
print(X.shape)
print(y.shape)

n,d = X.shape

y = y.reshape((36733, 1))

X = X * 10

print(y.shape)

A_train = torch.zeros(96, 300, 9)
B_train = torch.zeros(96, 300, 1)


for i in range(96):
        A_train[i] = torch.from_numpy(X[i * 300 : (i + 1) * 300, :])
        B_train[i] = torch.from_numpy(y[i * 300 : (i + 1) * 300])


        U, Sig, V = torch.svd(A_train[i])
        A_train[i] = A_train[i] / (Sig[0] / 100)

        U, Sig, V = torch.svd(B_train)
        B_train[i] = B_train[i] / (Sig[0] / 100)

A_test = torch.zeros(24, 300, 9)
B_test = torch.zeros(24, 300, 1)

for i in range(0, 24):
    i = 96 + i
    print(i)
    A_test[i - 96] = torch.from_numpy(X[i * 300 : (i + 1) * 300, :])
    B_test[i - 96] = torch.from_numpy(y[i * 300 : (i + 1) * 300])


for i in range(0, 24):

    U, Sig, V = torch.svd(A_test[i])

    A_test[i] = A_test[i] / (Sig[0] / 100)

    U, Sig, V = torch.svd(B_test)
    print(Sig[0])
    B_test[i] = B_test[i] / (Sig[0] / 100)



torch.save([A_train, B_train], "train96.dat")

torch.save([A_test, B_test], "test24.dat")
