import numpy as np
import torch




n = 1000
d = 30

def gen():
    g1 = np.random.uniform(-3, 3, size=n)
    g2 = np.random.uniform(-3, 3, size=n)
    g = []
    g.append(g1)
    g.append(g2)



    A = np.zeros(shape=(n, d))

    y = np.zeros(shape=(d, d))

    e = np.zeros(shape=(d, d))

    for i in range(d):
        ind = np.random.randint(0, 2)
        e[i][i] = 1
        y[i][i] = 2 * ind - 1

        for j in range(n):
            A[j][i] = np.random.normal(g[ind][j], 1)


    u, sig, v = np.linalg.svd(A)
    A = A / (sig[0] / 100)
    print(sig[0])




    B = np.hstack(((A @ y).T, e))


    return B.T






A_train = torch.zeros(270, 1030, 30)
A_test = torch.zeros(30, 1030, 30)

for i in range(0, 270):
    print(i)
    A_train[i] = torch.from_numpy(gen())

    if i < 30:
        A_test[i] = torch.from_numpy(gen())



torch.save(A_train, "train270.dat")

torch.save(A_test, "test30.dat")

