# GTrans


Implementation of "Empowering Graph Neural Networks with Test-Time Graph Transformation"

Abstract
----
As powerful tools for representation learning on graphs, graph neural networks (GNNs) have facilitated various applications from drug discovery to recommender systems. Nevertheless, the effectiveness of GNNs is immensely challenged by issues related to data quality, such as distribution shift, abnormal features and adversarial attacks. Recent efforts have been made on tackling these issues from a modeling perspective which requires additional cost of changing model architectures or re-training model parameters. In this work, we provide a data-centric view to tackle these issues and propose a graph transformation framework named GTRANS which adapts and refines graph data at test time to achieve better performance. We provide theoretical analysis on the design of the framework and discuss why adapting graph data works better than adapting the model. Extensive experiments have demonstrated the effectiveness of GTRANS on three distinct scenarios for eight benchmark datasets where suboptimal data is presented. Remarkably, GTRANS performs the best in most cases with improvements up to 2.8%, 8.2% and 3.8% over the best baselines on three experimental settings.



## Requirements
We used Python 3.7.10. For the Python packages, please see [requirements.txt]().
```
deeprobust==0.2.5
dgl==0.9.1
dgl_cu102==0.6.1
GCL==0.6.11
googledrivedownloader==0.4
ipdb==0.13.7
matplotlib==3.5.2
networkx==2.5
numpy==1.20.1
ogb==1.3.5
pandas==1.2.3
scikit_learn==1.1.3
scipy==1.6.2
torch==1.13.0
torch_geometric==2.0.1
torch_scatter==2.0.8
torch_sparse==0.6.12
tqdm==4.60.0
visualization==1.0.0
```

## Download Datasets
We used the datasets provided by [Wu et al.](https://github.com/qitianwu/GraphOOD-EERM). We slightly modified their code to support data loading and put the code in the `GraphOOD-EERM` folder. 

You can make a directory `./GraphOOD-EERM/data` and download all the datasets through the Google drive:
```
https://drive.google.com/drive/folders/15YgnsfSV_vHYTXe7I4e_hhGMcx0gKrO8?usp=sharing
```


## Run our code
Simply run the following command to get started.
```
python train_both_all.py --gpu_id=0 --dataset=cora --model=GCN  --seed=0
python train_both_all.py --gpu_id=0 --dataset=ogb-arxiv --model=GCN  --seed=0
python train_both_all.py --gpu_id=0 --dataset=elliptic --model=GCN  --seed=0
python train_both_all.py --gpu_id=0 --dataset=cora --model=SAGE  --seed=0
python train_both_all.py --gpu_id=0 --dataset=ogb-arxiv --model=SAGE  --seed=0
python train_both_all.py --gpu_id=0 --dataset=cora --model=GAT  --seed=0
```

You can also run the following script.
```
mkdir saved
bash script.sh 
```
You can also try different losses for test-time graph transformation:
```
python train_both_all.py --gpu_id=0 --dataset=cora --model=GCN  --seed=0 --debug=1 --loss=LC
python train_both_all.py --gpu_id=0 --dataset=cora --model=GCN  --seed=0 --debug=1 --loss=recon
python train_both_all.py --gpu_id=0 --dataset=cora --model=GCN  --seed=0 --debug=1 --loss=entropy
```


## Robustness
Go to the robustness folder
```
cd robustness
mkdir -p saved/attacked_graphs/
```
Run abnormal setting:
```
python train_both_abn.py  --model=GCN --debug=1 --gpu_id=0 --dataset=cora --noise_feature=0.2
```
Run adversarial attack:
```
python train_both_attack.py --dataset arxiv --model=GCN --seed=0 --ratio=0.1 --debug=1 --gpu_id=0
```



